package de.fzj.unicore.uas.impl.rns;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

import javax.xml.namespace.QName;

import org.apache.xmlbeans.XmlObject;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

import de.fzj.unicore.persist.PersistenceException;
import de.fzj.unicore.uas.rns.RNSEntryDoesNotExistFault;
import de.fzj.unicore.uas.rns.RNSEntryExistsFault;
import de.fzj.unicore.uas.rns.WriteNotPermittedFault;
import de.fzj.unicore.uas.util.LogUtil;
import de.fzj.unicore.wsrflite.Home;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.exceptions.ResourceUnknownException;
import de.fzj.unicore.wsrflite.xmlbeans.ResourceProperty;
import de.fzj.unicore.wsrflite.xmlbeans.impl.WSResourceImpl;

public class RPBasedRNSNode extends RNSNodeWithMetadata {
	

	private static final long serialVersionUID = 1L;

	private QName targetProperty;

	private String targetServiceName;

	private String targetServiceUUID;
	
	private XMLToNodeConverter converter;
	
	private transient Kernel kernel;
	
	
	
	public RPBasedRNSNode(Kernel kernel, String name, EndpointReferenceType epr, QName targetProperty, String targetServiceName,String targetServiceUUID, XMLToNodeConverter converter) {
		super(name,epr);
		this.targetProperty = targetProperty;
		this.targetServiceName = targetServiceName;
		this.targetServiceUUID = targetServiceUUID;
		this.converter = converter;
	}


	protected ResourceProperty<?> getTargetResourceProperty()throws ResourceUnknownException,PersistenceException{
		Home h=kernel.getHome(targetServiceName);
		WSResourceImpl inst=(WSResourceImpl)h.get(targetServiceUUID);
		ResourceProperty<?>rp=inst.getResourceProperty(targetProperty);
		
		return rp;
	}
	

	@SuppressWarnings("unchecked")
	@Override
	public Collection<RNSNode> getChildren() {
		try{
			XmlObject[] xmls=getTargetResourceProperty().getXml();
			return Arrays.asList(converter.convert(xmls));
			
		}catch(Exception ex){
			LogUtil.logException("Error creating RNS child list", ex);
		}
		return Collections.EMPTY_LIST;
	}


	@Override
	public RNSNode getChild(String name) {
		if(name == null) return null;
		for(RNSNode n : getChildren())
		{
			if(name.equals(n.getName())) return n;
		}
		return null;
	}


	@Override
	public void addChild(RNSNode child) throws WriteNotPermittedFault {
		throw new WriteNotPermittedFault(child.getName());
	}


	@Override
	public RNSNode removeChild(String name) throws RNSEntryDoesNotExistFault,
			WriteNotPermittedFault {
		throw new WriteNotPermittedFault(name);
	}


	@Override
	public RNSNode createDir(String name, boolean supportsRNS)
			throws WriteNotPermittedFault, RNSEntryExistsFault {
		throw new WriteNotPermittedFault(name);
	}
	
	@Override
	public RNSNode createFile(String name)
			throws WriteNotPermittedFault, RNSEntryExistsFault {
		throw new WriteNotPermittedFault(name);
	}


	public void setKernel(Kernel kernel) {
		this.kernel = kernel;
	}
	
	
}
