package de.fzj.unicore.uas.impl.rns;

import java.io.IOException;

import org.apache.commons.io.FilenameUtils;
import org.apache.xmlbeans.XmlException;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

import de.fzj.unicore.wsrflite.xmlbeans.WSUtilities;

public class RNSUtils {
	
	public static final String RNS_PATH_QUERY_PARAM = "&path=";
	public static final String RNS_PATH_QUERY_REGEXP = ".*&path=([^=]+).*";

	public static EndpointReferenceType getChildEPR(EndpointReferenceType myEPR, String childPath) throws XmlException, IOException 
	{
		childPath = FilenameUtils.normalizeNoEndSeparator(childPath, true);
		if(childPath == null) childPath = "/";
		if(!childPath.startsWith("/")) childPath = "/"+childPath;
		EndpointReferenceType child = null;

		child = EndpointReferenceType.Factory.parse(myEPR.newInputStream());
		int index = childPath.lastIndexOf("/");
		String friendlyName = childPath.substring(index);
		WSUtilities.removeFriendlyNameFromEPR(child);
		WSUtilities.addFriendlyName(child, friendlyName);
		String childURL = child.getAddress().getStringValue();
		if(!childURL.contains(RNS_PATH_QUERY_PARAM)) childURL+=RNS_PATH_QUERY_PARAM;
		String activityAddress = childURL+childPath;
		child.getAddress().setStringValue(activityAddress);
		return child;
	}
}
