package de.fzj.unicore.uas.impl.rns;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlObject;
import org.codehaus.xfire.transport.http.XFireServletController;
import org.ggf.rns.AddRequestDocument;
import org.ggf.rns.AddRequestType;
import org.ggf.rns.AddResponseDocument;
import org.ggf.rns.AddResponseType;
import org.ggf.rns.LookupRequestDocument;
import org.ggf.rns.LookupRequestType;
import org.ggf.rns.LookupResponseDocument;
import org.ggf.rns.LookupResponseType;
import org.ggf.rns.MetadataMappingType;
import org.ggf.rns.NameMappingType;
import org.ggf.rns.RNSEntryResponseType;
import org.ggf.rns.RNSEntryType;
import org.ggf.rns.RNSMetadataType;
import org.ggf.rns.RNSSupportType;
import org.ggf.rns.RemoveRequestDocument;
import org.ggf.rns.RemoveRequestType;
import org.ggf.rns.RemoveResponseDocument;
import org.ggf.rns.RemoveResponseType;
import org.ggf.rns.RenameRequestDocument;
import org.ggf.rns.RenameRequestType;
import org.ggf.rns.RenameResponseDocument;
import org.ggf.rns.RenameResponseType;
import org.ggf.rns.SetMetadataRequestDocument;
import org.ggf.rns.SetMetadataRequestType;
import org.ggf.rns.SetMetadataResponseDocument;
import org.ggf.rns.SetMetadataResponseType;

import de.fzj.unicore.uas.rns.RNSPortType;
import de.fzj.unicore.uas.util.LogUtil;
import de.fzj.unicore.uas.util.Pair;
import de.fzj.unicore.wsrflite.xmlbeans.BaseFault;
import de.fzj.unicore.wsrflite.xmlbeans.WSUtilities;

public class RNSSupport implements RNSPortType, Serializable {
	private static final long serialVersionUID = 1L;

	protected static final Logger logger=LogUtil.getLogger(LogUtil.SERVICES,RNSSupport.class);

	private static final Pattern pathPattern = Pattern.compile(RNSUtils.RNS_PATH_QUERY_REGEXP);
	
	private RNSNode rootNode;
	
	public RNSSupport(RNSNode rootNode)
	{
		this.rootNode = rootNode;
	}
	

	@Override
	public AddResponseDocument add(AddRequestDocument addRequest)  throws BaseFault {
		AddResponseDocument result = AddResponseDocument.Factory.newInstance();
		AddRequestType request = addRequest.getAddRequest();
		if(request == null)
		{
			logger.warn("Received empty request: "+ addRequest);
			return result;
		}
		AddResponseType response = result.addNewAddResponse();
		List<RNSNode> toAdd = new ArrayList<RNSNode>();
		RNSEntryType[] entries = request.getEntryArray();
		for(RNSEntryType entry : entries)
		{
			RNSNode node = new SimpleRNSNode(entry.getEntryName(), entry.getEndpoint());
			RNSMetadataType metaDataType = entry.getMetadata();
			XmlObject[] metaData = metaDataType == null ? null : WSUtilities.extractAllChildren(entry.getMetadata());
			node.setMetadata(metaData);
			boolean supportsRNS = metaDataType == null ? true : RNSSupportType.TRUE.equals(metaDataType.getSupportsRns().getValue());
			node.setSupportsRNS(supportsRNS);
			toAdd.add(node);
		}
		RNSNode targetNode = getRequestedNode();
		RNSOperationResult internalResult = targetNode.add(toAdd.toArray(new RNSNode[toAdd.size()]));
		for(int i = 0; i < internalResult.getSize();i++)
		{
			RNSEntryResponseType entry = response.addNewEntryResponse();
			fillEntry(entry, internalResult, i);
		}
		return result;
	}

	@Override
	public LookupResponseDocument lookup(LookupRequestDocument lookupRequest)  throws BaseFault {
		LookupResponseDocument result = LookupResponseDocument.Factory.newInstance();
		
		LookupRequestType request = lookupRequest.getLookupRequest();
		if(request == null)
		{
			logger.warn("Received empty request: "+ lookupRequest);
			return result;
		}
		LookupResponseType response = result.addNewLookupResponse();
		RNSNode targetNode = getRequestedNode();
		RNSOperationResult internalResult = targetNode.lookup(request.getEntryNameArray());
		for(int i = 0; i < internalResult.getSize(); i++)
		{
			RNSEntryResponseType entry = response.addNewEntryResponse();
			fillEntry(entry, internalResult, i);
		}
		
		return result;
	}

	@SuppressWarnings("unchecked")
	@Override
	public RenameResponseDocument rename(RenameRequestDocument renameRequest)  throws BaseFault {
		RenameResponseDocument result = RenameResponseDocument.Factory.newInstance();
		RenameRequestType request = renameRequest.getRenameRequest();
		if(request == null)
		{
			logger.warn("Received empty request: "+ renameRequest);
			return result;
		}
		RenameResponseType response = result.addNewRenameResponse();
		List<Pair<String,String>> toRename = new ArrayList<Pair<String,String>>();
		NameMappingType[] entries = request.getRenameRequestArray();
		for(NameMappingType entry : entries)
		{
			toRename.add(new Pair<String,String>(entry.getSourceName(),entry.getTargetName()));
		}
		RNSNode targetNode = getRequestedNode();
		RNSOperationResult internalResult = targetNode.rename(toRename.toArray(new Pair[toRename.size()]));
		for(int i = 0; i < internalResult.getSize();i++)
		{
			RNSEntryResponseType entry = response.addNewEntryResponse();
			fillEntry(entry, internalResult, i);
		}
		return result;
	}

	@Override
	public RemoveResponseDocument remove(RemoveRequestDocument removeRequest)  throws BaseFault {
		RemoveResponseDocument result = RemoveResponseDocument.Factory.newInstance();
		RemoveRequestType request = removeRequest.getRemoveRequest();
		if(request == null)
		{
			logger.warn("Received empty request: "+ removeRequest);
			return result;
		}
		RemoveResponseType response = result.addNewRemoveResponse();
		List<String> toRemove = new ArrayList<String>();
		String[] entries = request.getEntryNameArray();
		for(String entry : entries)
		{
			toRemove.add(entry);
		}
		RNSNode targetNode = getRequestedNode();
		RNSOperationResult internalResult = targetNode.remove(toRemove.toArray(new String[toRemove.size()]));
		for(int i = 0; i < internalResult.getSize();i++)
		{
			RNSEntryResponseType entry = response.addNewEntryResponse();
			fillEntry(entry, internalResult, i);
		}
		return result;
	}

	@SuppressWarnings("unchecked")
	@Override
	public SetMetadataResponseDocument setMetadata(SetMetadataRequestDocument setMetadataRequest) throws BaseFault {
		SetMetadataResponseDocument result = SetMetadataResponseDocument.Factory.newInstance();
		SetMetadataRequestType request = setMetadataRequest.getSetMetadataRequest();
		if(request == null)
		{
			logger.warn("Received empty request: "+ setMetadataRequest);
			return result;
		}
		SetMetadataResponseType response = result.addNewSetMetadataResponse();
		List<Pair<String,RNSMetadataType>> toSetMetadata = new ArrayList<Pair<String,RNSMetadataType>>();
		MetadataMappingType[] entries = request.getSetMetadataRequestArray();
		for(MetadataMappingType entry : entries)
		{
			RNSMetadataType setTo = RNSMetadataType.Factory.newInstance();
			setTo.setSupportsRns(entry.getSupportsRns());
			XmlObject[] metadata = WSUtilities.extractAllChildren(entry);
			WSUtilities.append(metadata, setTo);
			Pair<String,RNSMetadataType> pair = new Pair<String,RNSMetadataType>(entry.getEntryName(),setTo);
			toSetMetadata.add(pair);
		}
		RNSNode targetNode = getRequestedNode();
		RNSOperationResult internalResult = targetNode.setChildrenMetadata(toSetMetadata.toArray(new Pair[toSetMetadata.size()]));
		for(int i = 0; i < internalResult.getSize();i++)
		{
			RNSEntryResponseType entry = response.addNewEntryResponse();
			fillEntry(entry, internalResult, i);
		}
		return result;
	}
	
	protected void fillEntry(RNSEntryResponseType entry, RNSOperationResult internalResult, int i)
	{
		if(internalResult.wasSuccessful(i))
		{
			entry.setEndpoint(internalResult.getEPR(i));
			entry.setEntryName(internalResult.getName(i));
			entry.setMetadata(internalResult.getMetadata(i));
		}
		else
		{
			entry.setFault(internalResult.getFault(i).getFaultInfo());
		}
	}

	protected RNSNode getRequestedNode() throws BaseFault
	{
		String path = getRequestedPath();
		if(path.trim().length() > 0 && !"/".equals(path))
		{
			return getRootNode().getChildForPath(path);
		}
		else return getRootNode();
	}
	
	/**
	 * Obtain RNS path from the URL of the incoming request.. Careful! This uses
	 * a thread local variable!
	 * @return
	 */
	public String getRequestedPath()
	{
		 HttpServletRequest request = XFireServletController.getRequest(); 
		 String query=request.getQueryString();
		 Matcher m = pathPattern.matcher(query);
		 if(m.matches())
		 {
			 String result = m.group(1);
			 result = FilenameUtils.normalizeNoEndSeparator(result, true);
			 if(result == null || result.trim().length() == 0 || result.matches("/"))
			 {
				 return "/";
			 }
			 else return result;
		 }
		 else return "/";
	}


	public RNSNode getRootNode() {
		return rootNode;
	}


	public void setRootNode(RNSNode rootNode) {
		this.rootNode = rootNode;
	}
	
}
