package de.fzj.unicore.uas.impl.rns;

import java.util.ArrayList;
import java.util.List;

import org.ggf.rns.RNSMetadataType;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

import de.fzj.unicore.wsrflite.xmlbeans.BaseFault;

public class RNSOperationResult {

	private List<BaseFault> occuredFaults = new ArrayList<BaseFault>();

	private List<String> names = new ArrayList<String>();
	
	protected List<EndpointReferenceType> eprs = new ArrayList<EndpointReferenceType>();
	protected List<RNSMetadataType> metaData = new ArrayList<RNSMetadataType>();
	
	public void addEPR(EndpointReferenceType epr)
	{
		eprs.add(epr);
	}
	
	public void addMetadata(RNSMetadataType meta)
	{
		metaData.add(meta);
	}
	
	public EndpointReferenceType getEPR(int index)
	{
		return eprs.get(index);
	}
	
	
	
	public RNSMetadataType getMetadata(int index)
	{
		return metaData.get(index);
	}


	public void addName(String name)
	{
		names.add(name);
	}


	public String getName(int index)
	{
		return names.get(index);
	}


	public int getSize()
	{
		return eprs.size();
	}

	public void addFault(BaseFault e)
	{
		occuredFaults.add(e);
	}

	public void addSuccess()
	{
		occuredFaults.add(null);
	}

	public boolean wasSuccessful(int index)
	{
		return occuredFaults.get(index) == null;
	}

	public BaseFault getFault(int index)
	{
		return occuredFaults.get(index);
	}


}
