package de.fzj.unicore.uas.impl.rns;

import java.util.Collection;

import org.apache.xmlbeans.XmlObject;
import org.ggf.rns.RNSMetadataType;
import org.ggf.rns.RNSSupportType;
import org.ggf.rns.SupportsRNSType;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

import de.fzj.unicore.wsrflite.xmlbeans.WSUtilities;

public abstract class RNSNodeWithMetadata extends BasicRNSNode {

	
	private static final long serialVersionUID = 1L;


	/**
	 * States whether the node itself supports RNS operations and can have 
	 * children.. This is NOT self-evident for the leafs of the RNS tree
	 */
	private boolean supportsRNS = true;
	
	
	private XmlObject[] metaData;
	
	public RNSNodeWithMetadata(String name, EndpointReferenceType epr,
			Collection<RNSNode> kids) {
		super(name, epr, kids);
	}

	public RNSNodeWithMetadata(String name, EndpointReferenceType epr,
			RNSNode... children) {
		super(name, epr, children);
	}

	public RNSNodeWithMetadata(String name, EndpointReferenceType epr) {
		super(name, epr);
	}

	public RNSNodeWithMetadata(String name) {
		super(name);
	}

	
	@Override
	public XmlObject[]getMetadata() {
		return metaData;
	}

	@Override
	public RNSMetadataType getMetadataType() {
		RNSMetadataType result = RNSMetadataType.Factory.newInstance();
		SupportsRNSType supportsRNS = result.addNewSupportsRns();
		if(getSupportsRNS()) supportsRNS.setValue(RNSSupportType.TRUE);
		else supportsRNS.setValue(RNSSupportType.FALSE);
		if(metaData != null) WSUtilities.append(metaData,result);
		return result;
	}

	
	@Override
	public void setMetadata(XmlObject[] value) {
		this.metaData = value;
	}
	
	public void setSupportsRNS(boolean supportsRNS)
	{
		this.supportsRNS = supportsRNS;
	}
	
	
	
	public  boolean getSupportsRNS()
	{
		return supportsRNS;
	}

}
