package de.fzj.unicore.uas.impl.rns;

import java.util.Calendar;

import javax.xml.namespace.QName;

import org.apache.xmlbeans.XmlObject;

import de.fzj.unicore.wsrflite.xmlbeans.BaseFault;
import de.fzj.unicore.wsrflite.xmlbeans.ResourceProperty;
import de.fzj.unicore.wsrflite.xmlbeans.exceptions.InvalidResourcePropertyQNameFault;
import de.fzj.unicore.wsrflite.xmlbeans.exceptions.ResourceNotDestroyedFault;
import de.fzj.unicore.wsrflite.xmlbeans.exceptions.ResourceUnavailableFault;
import de.fzj.unicore.wsrflite.xmlbeans.exceptions.ResourceUnknownFault;
import de.fzj.unicore.wsrflite.xmlbeans.exceptions.TerminationTimeChangeRejectedFault;
import de.fzj.unicore.wsrflite.xmlbeans.exceptions.UnableToSetTerminationTimeFault;

/**
 * This class is used in conjunction with a {@link WSRFMethodMultiplexer} in
 * order to gain some flexibility regarding how WSRF-operations are handled in
 * case of virtual WS-Resources. The idea is that the 
 * {@link WSRFMethodMultiplexer} identfies the correct virtual resource which is
 * targeted by the incoming WSRF operation and then delegates to an instance of
 * this interface for actually handling the operation.
 * @author bdemuth
 *
 */
public interface RNSNodeWSRFHandler {


	public void destroy(RNSNode node)
	throws ResourceNotDestroyedFault, ResourceUnknownFault,
	ResourceUnavailableFault;


	public void setTerminationTime(RNSNode node, Calendar terminationTime)
	throws UnableToSetTerminationTimeFault,
	TerminationTimeChangeRejectedFault, ResourceUnknownFault,
	ResourceUnavailableFault;


	public void deleteResourceProperties(RNSNode node, QName... properties) throws ResourceUnknownFault,
	ResourceUnavailableFault, BaseFault;


	public void insertResourceProperty(
			RNSNode node, XmlObject[] toInsert) throws ResourceUnknownFault,
			ResourceUnavailableFault, BaseFault;


	public QName getResourcePropertyDocumentQName();

	public QName[] getResourcePropertyQNames();


	public void updateResourceProperty(RNSNode node, QName name, XmlObject[] prop) throws ResourceUnknownFault,
	ResourceUnavailableFault, BaseFault;

	public ResourceProperty<?> getResourceProperty(RNSNode node, QName property)
	throws BaseFault, ResourceUnknownFault, ResourceUnavailableFault,
	InvalidResourcePropertyQNameFault;


	public ResourceProperty<?>[]  getMultipleResourceProperties(
			RNSNode node, QName[] properties)
			throws ResourceUnknownFault, ResourceUnavailableFault, BaseFault;

}
