package de.fzj.unicore.uas.impl.rns;

import java.io.Serializable;
import java.util.Collection;

import org.apache.xmlbeans.XmlObject;
import org.ggf.rns.RNSMetadataType;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

import de.fzj.unicore.uas.rns.RNSEntryDoesNotExistFault;
import de.fzj.unicore.uas.rns.RNSEntryExistsFault;
import de.fzj.unicore.uas.rns.WriteNotPermittedFault;
import de.fzj.unicore.uas.util.Pair;
import de.fzj.unicore.wsrflite.xmlbeans.BaseFault;


public interface RNSNode extends Comparable<RNSNode>, Serializable {


	/**
	 * POJO replacement for RNS add operation.. trying to clutter the logic as
	 * little as possible with Xmlbeans code
	 * @param children
	 * @return
	 */
	public RNSOperationResult add(RNSNode... children);

	/**
	 * POJO replacement for RNS lookup operation.. trying to clutter the logic as
	 * little as possible with Xmlbeans code 
	 * @param names
	 * @return
	 * @throws BaseFault 
	 */
	public RNSOperationResult lookup(String... names) throws BaseFault;

	/**
	 * POJO replacement for RNS rename operation.. trying to clutter the logic as
	 * little as possible with Xmlbeans code
	 * @param namePairs
	 * @return
	 */
	public RNSOperationResult rename(Pair<String, String>... namePairs);

	/**
	 * POJO replacement for RNS remove operation.. trying to clutter the logic as
	 * little as possible with Xmlbeans code
	 * @param names
	 * @return
	 */
	public RNSOperationResult remove(String... names);
	
	/**
	 * POJO replacement for RNS setMetadata operation.. trying to clutter the logic as
	 * little as possible with Xmlbeans code
	 * @param names
	 * @return
	 */
	public RNSOperationResult setChildrenMetadata(Pair<String,RNSMetadataType>... metadata);

	/**
	 * Return the node's RNS name
	 * @return
	 */
	public String getName();
	
	/**
	 * Set the node's RNS name. Handling of name clashes and throwing of 
	 * {@link RNSEntryExistsFault} must be done by the parent (cause the node
	 * doesn't know its siblings). 
	 * @param name
	 */
	public void setName(String name);

	/**
	 * Returns a READ-ONLY list of children
	 * @return
	 */
	public Collection<RNSNode> getChildren() throws BaseFault;

	/**
	 * Retrieves a single child by name
	 * @param name
	 * @return
	 * @throws RNSEntryDoesNotExistFault 
	 */
	public RNSNode getChild(String name) throws BaseFault;
	
	/**
	 * Retrieves a descendant (child, grandchild, great-grandchild,...) by
	 * looking at a path of names of the form childName/grandChildName/...
	 * This usually means walking down the tree of RNS nodes, but it doesn't
	 * have to...
	 * @param path
	 * @return
	 * @throws RNSEntryDoesNotExistFault
	 */
	public RNSNode getChildForPath(String path) throws BaseFault;

	/**
	 * Create a new child directory and return it for convenience
	 * @param name
	 * @param supportsRNS
	 * @return
	 * @throws WriteNotPermittedFault
	 * @throws RNSEntryExistsFault
	 */
	public RNSNode createDir(String name, boolean supportsRNS) throws BaseFault;
	
	/**
	 * Create a new file and return it for convenience
	 * @param name
	 * @return
	 * @throws BaseFault
	 */
	public RNSNode createFile(String name) throws BaseFault;
	
	/**
	 * Adds a child to the node. MUST throw a {@link RNSEntryExistsFault} if a
	 * child with the same name exists!
	 * @param child
	 * @throws RNSEntryExistsFault
	 * @throws WriteNotPermittedFault
	 */
	public void addChild(RNSNode child) throws BaseFault;
	
	public RNSNode removeChild(String name) throws BaseFault;

	/**
	 * Returns the node's own EPR
	 * @return
	 */
	public EndpointReferenceType getEPR();

	public XmlObject[] getMetadata();
	
	public RNSMetadataType getMetadataType();

	public void setMetadata(XmlObject[] value);
	
	/**
	 * Set whether the node itself supports RNS operations and can have 
	 * children.. This is NOT self-evident for the leafs of the RNS tree
	 */
	public void setSupportsRNS(boolean supportsRNS);
	
	public boolean getSupportsRNS();

}
