package de.fzj.unicore.uas.impl.rns;

import de.fzj.unicore.uas.rns.ExtendedRNSPortType;
import de.fzj.unicore.wsrflite.xmlbeans.BaseFault;
import edu.virginia.cs.vcgr.container.x2011.x04.enhancedRns.CreateFileRequestType;
import edu.virginia.cs.vcgr.container.x2011.x04.enhancedRns.CreateFileRequestTypeDocument;
import edu.virginia.cs.vcgr.container.x2011.x04.enhancedRns.CreateFileResponseType;
import edu.virginia.cs.vcgr.container.x2011.x04.enhancedRns.CreateFileResponseTypeDocument;


/**
 * The original RNS spec does not define an operation for creating files,
 * but there is one for creating folders which seems a little odd. 
 * To fill the gap, the UVA guys (University of Virginia) came up with a
 * "createFile" operation which we also implemented in this class.
 * @author bdemuth
 *
 */
public class ExtendedRNSSupport extends RNSSupport implements ExtendedRNSPortType {



	private static final long serialVersionUID = 1L;

	public ExtendedRNSSupport(RNSNode rootNode) {
		super(rootNode);
	}

	/**
	 * Create an empty file which might later be written to via ByteIO.
	 */
	public CreateFileResponseTypeDocument createFile(
			CreateFileRequestTypeDocument createFileRequest) throws BaseFault {
		CreateFileResponseTypeDocument result = CreateFileResponseTypeDocument.Factory.newInstance();
		CreateFileRequestType request = createFileRequest.getCreateFileRequestType();
		if(request == null)
		{
			logger.warn("Received empty request: "+ createFileRequest);
			return result;
		}
		CreateFileResponseType response = result.addNewCreateFileResponseType();
		String filename = request.getFilename();
		RNSNode targetNode = getRequestedNode();
		RNSNode internalResult = targetNode.createFile(filename);
		response.addNewEndpoint();
		response.setEndpoint(internalResult.getEPR());
		
		return result;
	}

}
