package de.fzj.unicore.uas.impl.rns;

import java.util.ArrayList;
import java.util.List;

import org.apache.xmlbeans.XmlObject;
import org.w3.x2005.x08.addressing.EndpointReferenceDocument;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

import de.fzj.unicore.wsrflite.xmlbeans.WSUtilities;

public abstract class EPRToNodeConverter implements XMLToNodeConverter {

	
	private static final long serialVersionUID = 1L;

	@Override
	public RNSNode[] convert(XmlObject[] xml) {
		String fallBackName = getFallBackName();
		int count = 1;
		List<RNSNode> result = new ArrayList<RNSNode>();
		for(XmlObject o : xml)
		{
			if(o instanceof EndpointReferenceDocument)
			{
				EndpointReferenceType epr = ((EndpointReferenceDocument) o).getEndpointReference();
				String friendlyName = WSUtilities.extractFriendlyNameFromEPR(epr);
				if(friendlyName == null)
				{
					friendlyName = fallBackName+count++;
				}
				SimpleRNSNode node = new SimpleRNSNode(friendlyName, epr);
				result.add(node);
			}
		}
		
		return result.toArray(new RNSNode[result.size()]);
	}
	
	protected abstract String getFallBackName();

}

