/*********************************************************************************
 * Copyright (c) 2006-2008 Forschungszentrum Juelich GmbH 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * (1) Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer at the end. Redistributions in
 * binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other
 * materials provided with the distribution.
 * 
 * (2) Neither the name of Forschungszentrum Juelich GmbH nor the names of its 
 * contributors may be used to endorse or promote products derived from this 
 * software without specific prior written permission.
 * 
 * DISCLAIMER
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 ********************************************************************************/
 

package de.fzj.unicore.uas.impl.reservation;

import org.unigrids.x2006.x04.services.reservation.ReservationStatusDescriptionDocument;

import de.fzj.unicore.wsrflite.xmlbeans.ResourceProperty;
import de.fzj.unicore.xnjs.ems.ExecutionException;
import de.fzj.unicore.xnjs.tsi.ReservationStatus;

/**
 * Represents the status description of a resource reservation
 * @since 1.5.1
 */
public class ReservationStatusDescriptionResourceProperty extends ResourceProperty<Object> {

	private static final long serialVersionUID=1L;
	
	private final ReservationStatusDescriptionDocument status;
	private final ReservationStatusDescriptionDocument[] xdoc;
	
	/**
	 * 
	 * @param jobID the id of the job
	 */
	public ReservationStatusDescriptionResourceProperty(ReservationManagementImpl parent){
		super(parent);
		status=ReservationStatusDescriptionDocument.Factory.newInstance();
		status.setReservationStatusDescription(null);
		xdoc=new ReservationStatusDescriptionDocument[]{status};
	}

	@Override
	public ReservationStatusDescriptionDocument[] getXml() {
		return xdoc;
	}

	/**
	 *
	 * @see de.fzj.unicore.wsrflite.ResourceProperty#update()
	 */
	@Override
	public ReservationStatusDescriptionResourceProperty update() throws Exception{
		try{
			ReservationStatus reservationStatus=((ReservationManagementImpl)parentWSResource).getReservationStatus();
			status.setReservationStatusDescription(reservationStatus.getDescription());
		}catch(ExecutionException ex){
			status.setReservationStatusDescription(null);
		}
		return this;
	}
}