package de.fzj.unicore.uas.impl.job;

import org.unigrids.x2006.x04.services.jms.StdOutDocument;

import de.fzj.unicore.uas.xnjs.XNJSFacade;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.Resource;
import de.fzj.unicore.wsrflite.xmlbeans.ResourceProperty;

public class StdOutProperty extends ResourceProperty<String> {

	private static final long serialVersionUID = 1L;

	private final String actionID;
	private final String xnjsReference;
	
	private String sOut;
	
	public StdOutProperty(Resource parent,String actionID,String xnjsReference){
		super(parent);
		this.actionID=actionID;
		sOut="stdout";
		this.xnjsReference=xnjsReference;
	}
	
	@Override
	public StdOutDocument[] getXml() {
		StdOutDocument s=StdOutDocument.Factory.newInstance();
		s.setStdOut(sOut);
		return new StdOutDocument[]{s};
	}

	@Override
	public StdOutProperty update() throws Exception {
		try{
			Kernel k=parentWSResource.getKernel();
			sOut=XNJSFacade.get(xnjsReference,k).getAction(actionID).getExecutionContext().getStdout();
		}catch(Exception e){
			sOut="stdout";
		}
		return this;
	}

	@Override
	public String getProperty() {
		return sOut;
	}
}
