package de.fzj.unicore.uas.impl.job;

import org.unigrids.x2006.x04.services.jms.StdErrDocument;

import de.fzj.unicore.uas.xnjs.XNJSFacade;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.Resource;
import de.fzj.unicore.wsrflite.xmlbeans.ResourceProperty;

public class StdErrProperty extends ResourceProperty<String> {

	private static final long serialVersionUID = 1L;

	private final String actionID;
	
	private final String xnjsReference;
	
	private String sErr;
	
	public StdErrProperty(Resource parent, String actionID,String xnjsReference){
		super(parent);
		this.actionID=actionID;
		sErr="stderr";
		this.xnjsReference=xnjsReference;
	}
	
	@Override
	public StdErrDocument[] getXml() {
		StdErrDocument s=StdErrDocument.Factory.newInstance();
		s.setStdErr(sErr);
		return new StdErrDocument[]{s};
	}

	@Override
	public StdErrProperty update() throws Exception {
		try{
			Kernel k=parentWSResource.getKernel();
			sErr=XNJSFacade.get(xnjsReference,k).getAction(actionID).getExecutionContext().getStderr();
		}catch(Exception e){
			sErr="stderr";
		}
		return this;
	}

	@Override
	public String getProperty() {
		return sErr;
	}
}
