/*********************************************************************************
 * Copyright (c) 2006 Forschungszentrum Juelich GmbH 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * (1) Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer at the end. Redistributions in
 * binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other
 * materials provided with the distribution.
 * 
 * (2) Neither the name of Forschungszentrum Juelich GmbH nor the names of its 
 * contributors may be used to endorse or promote products derived from this 
 * software without specific prior written permission.
 * 
 * DISCLAIMER
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 ********************************************************************************/
 

package de.fzj.unicore.uas.impl.job;

import java.util.List;

import org.unigrids.x2006.x04.services.jms.LogDocument;

import de.fzj.unicore.uas.xnjs.XNJSFacade;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.Resource;
import de.fzj.unicore.wsrflite.xmlbeans.ResourceProperty;

/**
 * Contains the job log (which is copied from the XNJS Action log)
 */
public class LogResourceProperty extends ResourceProperty<String>{
	
	private static final long serialVersionUID=20348L;
	
	private LogDocument status;
	
	private LogDocument[] xdoc;
	
	private final String actionId;
	private final String xnjsReference;
	
	/**
	 * 
	 * @param jobID the id of the job
	 */
	public LogResourceProperty(Resource parent, String jobID, String xnjsReference){
		super(parent);
		status=LogDocument.Factory.newInstance();
		status.setLog("");
		xdoc=new LogDocument[]{status};
		this.actionId=jobID;
		this.xnjsReference=xnjsReference;
	}
	
	@Override
	public String getProperty() {
		return status.getLog();
	}

	@Override
	public LogDocument[] getXml() {
		return xdoc;
	}

	@Override
	public void setProperty(String log) {
		status.setLog(log);
	}

	/**
	 *
	 * @see de.fzj.unicore.wsrflite.ResourceProperty#update()
	 */
	@Override
	public LogResourceProperty update() throws Exception{
		Kernel k=parentWSResource.getKernel();
		StringBuffer sb=new StringBuffer();
		List<String> l=XNJSFacade.get(xnjsReference,k).getAction(actionId).getLog();
		for(String s:l)sb.append(s+"\n");
		status.setLog(sb.toString());
		return this;
	}
	
}
