/*********************************************************************************
 * Copyright (c) 2006 Forschungszentrum Juelich GmbH 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * (1) Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer at the end. Redistributions in
 * binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other
 * materials provided with the distribution.
 * 
 * (2) Neither the name of Forschungszentrum Juelich GmbH nor the names of its 
 * contributors may be used to endorse or promote products derived from this 
 * software without specific prior written permission.
 * 
 * DISCLAIMER
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 ********************************************************************************/
 

package de.fzj.unicore.uas.impl.job;

import org.ggf.schemas.jsdl.x2005.x11.jsdl.JobDefinitionDocument;
import org.unigrids.x2006.x04.services.jms.ExecutionJSDLDocument;

import de.fzj.unicore.uas.xnjs.XNJSFacade;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.Resource;
import de.fzj.unicore.wsrflite.xmlbeans.ResourceProperty;

/**
 * Contains the JSDL job description that is actually executed by the XNJS 
 * after incarnation
 */
public class ExecutionJSDLResourceProperty extends ResourceProperty<Object> {
	
	private static final long serialVersionUID=20348L;
	
	private ExecutionJSDLDocument[] xdoc;
	
	private String actionId;
	private String xnjsReference;
	
	/**
	 * 
	 * @param jobID the id of the job
	 */
	public ExecutionJSDLResourceProperty(Resource parent, String jobID, String xnjsReference){
		super(parent);
		this.actionId=jobID;
		this.xnjsReference=xnjsReference;
		xdoc=new ExecutionJSDLDocument[1];
		
	}
	
	@Override
	public ExecutionJSDLDocument getProperty() {
		return xdoc[0];
	}

	@Override
	public ExecutionJSDLDocument[] getXml() {
		return xdoc;
	}

	@Override
	public ExecutionJSDLResourceProperty update() throws Exception{
		Kernel k=parentWSResource.getKernel();
		JobDefinitionDocument jdd=(JobDefinitionDocument)XNJSFacade.get(xnjsReference,k).getAction(actionId).getAjd();
		ExecutionJSDLDocument ejd=ExecutionJSDLDocument.Factory.newInstance();
		ejd.setExecutionJSDL(jdd.getJobDefinition());
		xdoc[0]=ejd;
		return this;
	}
	
}
