package de.fzj.unicore.uas.impl.enumeration;

import java.util.List;
import java.util.Map;

import javax.xml.namespace.QName;

import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlObject;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

import de.fzj.unicore.persist.PersistenceException;
import de.fzj.unicore.uas.Enumeration;
import de.fzj.unicore.uas.client.BaseUASClient;
import de.fzj.unicore.uas.impl.UASWSResourceImpl;
import de.fzj.unicore.uas.util.LogUtil;
import de.fzj.unicore.wsrflite.Home;
import de.fzj.unicore.wsrflite.exceptions.ResourceUnknownException;
import de.fzj.unicore.wsrflite.persistence.Persist;
import de.fzj.unicore.wsrflite.xmlbeans.BaseFault;
import de.fzj.unicore.wsrflite.xmlbeans.ResourceProperty;
import de.fzj.unicore.wsrflite.xmlbeans.WSUtilities;
import de.fzj.unicore.wsrflite.xmlbeans.impl.WSResourceImpl;
import eu.unicore.unicore6.enumeration.EnumerationPropertiesDocument;
import eu.unicore.unicore6.enumeration.GetResultsRequestDocument;
import eu.unicore.unicore6.enumeration.GetResultsResponseDocument;
import eu.unicore.unicore6.enumeration.GetResultsResponseDocument.GetResultsResponse;
import eu.unicore.unicore6.enumeration.ResultsDocument;

public class EnumerationImpl extends UASWSResourceImpl implements Enumeration {

	private static final Logger logger=LogUtil.getLogger(LogUtil.SERVICES,EnumerationImpl.class);

	@Persist
	private QName targetProperty;
	@Persist
	private String targetServiceName;
	@Persist
	private String targetServiceUUID;
	@Persist
	EndpointReferenceType targetServiceEPR;
	
	
	//init parameter keys
	public static final String INIT_TARGETSERVICE_EPR="targetServiceEPR";
	public static final String INIT_TARGETSERVICE_RP="targetPropertyQName";
	
	//for unit testing
	private ResourceProperty<?>rp;
	static final String INIT_TARGETSERVICE_RP_OBJECT="targetProperty";
	
	public GetResultsResponseDocument GetResults(GetResultsRequestDocument in)
			throws BaseFault {
		try{
			int offset=(int)in.getGetResultsRequest().getOffset();
			int length=(int)in.getGetResultsRequest().getNumberOfResults();
			GetResultsResponseDocument resD=GetResultsResponseDocument.Factory.newInstance();
			GetResultsResponse res=resD.addNewGetResultsResponse();
			ResultsDocument d=ResultsDocument.Factory.newInstance();
			d.addNewResults();
			List<XmlObject>xmls=getTargetResourceProperty().getXml(offset, length);
			for(XmlObject o: xmls){
				WSUtilities.append(o, d);
			}
			res.setResults(d.getResults());
			return resD;
		}catch(Exception ex){
			String msg=LogUtil.createFaultMessage("Error creating result list", ex);
			throw BaseFault.createFault(msg, ex);
		}
	}

	@Override
	public void initialise(String serviceName, Map<String, Object> initParams)
			throws Exception {
		super.initialise(serviceName, initParams);
		this.targetProperty=(QName)initParams.get(INIT_TARGETSERVICE_RP);
		this.targetServiceEPR=(EndpointReferenceType)initParams.get(INIT_TARGETSERVICE_EPR);
		if(targetServiceEPR!=null){
			this.targetServiceName=WSUtilities.extractServiceName(targetServiceEPR);
			this.targetServiceUUID=WSUtilities.extractResourceID(targetServiceEPR);;
		}
		//for unittesting
		this.rp=(ResourceProperty<?>)initParams.get(INIT_TARGETSERVICE_RP_OBJECT);
		
		NumberOfResultsRP nRP=new NumberOfResultsRP(this);
		properties.put(RPNumResults, nRP);
		
		ParentServiceEPRRP pRP=new ParentServiceEPRRP(this);
		properties.put(RPParentServiceReference, pRP);		
	}



	protected ResourceProperty<?> getTargetResourceProperty()throws ResourceUnknownException,PersistenceException{
		if(rp!=null)return rp;
		checkAndUpdateParent();
		Home h=kernel.getHome(targetServiceName);
		WSResourceImpl inst=(WSResourceImpl)h.get(targetServiceUUID);
		ResourceProperty<?>rp=inst.getResourceProperty(targetProperty);
		return rp;
	}
	
	protected void checkAndUpdateParent(){
		try{
			if(kernel.getMessaging().hasMessages(targetServiceUUID)){
				BaseUASClient c=new BaseUASClient(targetServiceEPR, kernel.getClientConfiguration());
				c.getCurrentTime();
				if(logger.isDebugEnabled()){
					logger.debug("Updated parent service "+targetServiceEPR.getAddress().getStringValue());
				}
			}
		}catch(Exception ex){
			LogUtil.logException("Error updating parent service.", ex);
		}
	}
	
	@Override
	public QName getResourcePropertyDocumentQName() {
		return EnumerationPropertiesDocument.type.getDocumentElementName();
	}

	
	
}
