package de.fzj.unicore.uas.fts.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.xnjs.io.IStorageAdapter;

/**
 * Directory version of {@link UResource}.<br/> 
 * It does not do much, but might be extended to
 * provide directory listing (via #list() and #addPath())
 * 
 * @author schuller
 * @since 1.6.0
 */
public class UDirectoryResource extends UResource {
	
	public UDirectoryResource(String id, String path, IStorageAdapter storage, Kernel kernel){
		super(id,path,storage,kernel);
	}
	
	@Override
	public InputStream getInputStream() throws IOException {
		return null;
	}

	@Override
	public String getName() {
		return path;
	}

	@Override
	public OutputStream getOutputStream() throws IOException, SecurityException {
		return null;
	}

	@Override
	public boolean isDirectory() {
		return true;
	}

	@Override
	public long length() {
		return 0;
	}

}
