package de.fzj.unicore.uas.fts.byteio;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;

import org.apache.log4j.Logger;

import de.fzj.unicore.uas.util.LogUtil;
import de.fzj.unicore.xnjs.ems.ExecutionException;
import de.fzj.unicore.xnjs.io.IStorageAdapter;
import de.fzj.unicore.xnjs.io.XnjsFile;
import de.fzj.unicore.xnjs.simple.LocalTS;

public class StorageAdapterRByteIOSupport extends RandomByteIOSupport {

	private static final Logger logger=LogUtil.getLogger(LogUtil.SERVICES,StorageAdapterRByteIOSupport.class);

	private IStorageAdapter storageAdapter;
	private String resourcePath;
	
	public StorageAdapterRByteIOSupport(IStorageAdapter storageAdapter,
			String resourcePath) {
		super();
		this.storageAdapter = storageAdapter;
		this.resourcePath = resourcePath;
	}

	public byte[] read(long offset,
			long bytesPerBlock, 
			long numBlocks, 
			long stride)
	throws IOException {
		try {
			ByteArrayOutputStream os = new ByteArrayOutputStream();
			InputStream is=createInputStream();
			try{
				byte[] data=new byte[(int)bytesPerBlock];
				long skipped=is.skip(offset);
				if(skipped<offset){
					throw new IOException("Attempted to offset past end of file.");
				}
				for (int block=0; block<numBlocks; block++) {
					int read=is.read(data);
					if (read > 0) {
						bytesRead(read);
						os.write(data,0,read);
					}
					if(stride>0){
						if(is!=null)is.close();
						is=createInputStream();
						long t=offset+stride*(block+1);
						skipped=is.skip(t);
						if(skipped<t){
							throw new IOException("Attempted to skip past end of file.");
						}
					}
				}
				return os.toByteArray();
			}finally{
				try{is.close();}catch(Exception e){}
			}
		}
		catch(ExecutionException w)
		{
			throw new IOException(w.getMessage(),w.getCause());

		}
	}

	public void write(byte[] data, long initialOffset, long bytesPerBlock, long stride) throws IOException {
		try {
			//do we use a local TS ? if yes use RandomAccessFile
			IStorageAdapter tsi=getStorageAdapter();
			if(tsi instanceof LocalTS){
				String file=getResourcePath();
				RandomAccessFile f=((LocalTS)tsi).getRandomAccessFile(file);
				try {
					int off = 0;
					while (off < data.length) {
						int toWrite = (data.length - off);
						if (toWrite > bytesPerBlock){
							toWrite = (int)bytesPerBlock;
						}
						if(initialOffset!=0)f.seek(initialOffset);
						f.write(data, off, toWrite);
						bytesWritten(toWrite);
						initialOffset+= stride;
						off += toWrite;
					}
				} finally{
					if(f!=null)f.close();
				}
			}
			else{
				//fallback to output stream -> not all parameter combinations are supported
				writeToOutputStream(data, initialOffset, bytesPerBlock, stride);
			}
		}
		catch(ExecutionException w)
		{
			throw new IOException(w.getMessage(),w.getCause());

		}
	}

	protected void writeToOutputStream(byte[] data, long initialOffset, long bytesPerBlock, long stride)throws IOException,ExecutionException{
		//else check if we can make sense of the params
		if(initialOffset>0) //we can only write a new file or else append 
		{
			throw new IllegalArgumentException("Can't fulfil write request.");
		}
		OutputStream os=createOutputStream(false);
		os.write(data,0,(int)bytesPerBlock);
		bytesWritten(bytesPerBlock);
		os.close();
	}

	public void append(byte[] data)throws IOException {
		try {
			//boolean append=... TODO check this 
			OutputStream os=createOutputStream(true);
			os.write(data);
			bytesAppended(data.length);
			os.flush();
			os.close();
		}
		catch(ExecutionException w)
		{
			throw new IOException(w.getMessage(),w.getCause());

		}
	}

	public void truncAppend(byte[] data, long offset)throws IOException {

		// offset is zero meaning "create new file"
		if(offset==0){
			write(data, 0, data.length, data.length);
			return;
		}
		
		//check if file size equals offset
		if(getDataSize()!=offset){
			throw new IOException("Truncate is not supported.");
		}
		else append(data);
	}

	protected IStorageAdapter getStorageAdapter()
	{
		return storageAdapter;
	}

	protected String getResourcePath()
	{
		return resourcePath;
	}

	protected void bytesRead(long bytes)
	{
		// do nothing by default.. override if you're interested
	}
	protected void bytesWritten(long bytes)
	{
		// do nothing by default.. override if you're interested
	}
	protected void bytesAppended(long bytes)
	{
		// do nothing by default.. override if you're interested
	}

	protected long getDataSize(){
		String filename=getResourcePath();
		try{
			XnjsFile f=getStorageAdapter().getProperties(filename);
			if(f!=null){
				return f.getSize();
			}
		}catch(Exception e){
			LogUtil.logException("Could not determine file size for <"+filename+">",e,logger);
		}

		return 0L;
	}

	protected InputStream createInputStream()throws IOException,ExecutionException{
		InputStream is=getStorageAdapter().getInputStream(getResourcePath());
		return is;
	}

	protected OutputStream createOutputStream(boolean append)throws IOException,ExecutionException{
		OutputStream os=getStorageAdapter().getOutputStream(getResourcePath(),append);
		return os;
	}


}
