/*********************************************************************************
 * Copyright (c) 2011 Forschungszentrum Juelich GmbH 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * (1) Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer at the end. Redistributions in
 * binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other
 * materials provided with the distribution.
 * 
 * (2) Neither the name of Forschungszentrum Juelich GmbH nor the names of its 
 * contributors may be used to endorse or promote products derived from this 
 * software without specific prior written permission.
 * 
 * DISCLAIMER
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 ********************************************************************************/
 

package de.fzj.unicore.uas.fts;

import java.util.List;

import org.unigrids.services.atomic.types.ProtocolDocument;
import org.unigrids.services.atomic.types.ProtocolType;

import de.fzj.unicore.uas.UASProperties;
import de.fzj.unicore.uas.impl.sms.SMSBaseImpl;
import de.fzj.unicore.uas.impl.sms.StorageDescription;
import de.fzj.unicore.wsrflite.Resource;
import de.fzj.unicore.wsrflite.xmlbeans.rp.UpdatingResourceProperty;

/**
 * Property representing a dynamic list of supported filetransfer protocols
 * which is updated from a property as needed
 * 
 * @author schuller
 */
public class UpdatingProtocolRP extends UpdatingResourceProperty<ProtocolType.Enum[]>{

	private static final long serialVersionUID = 1L;

	private ProtocolDocument[] xdoc;
	private ProtocolType.Enum[] protocols;

	private final StorageDescription sd;
	
	public UpdatingProtocolRP(Resource parent, StorageDescription sd){
		super(parent);
		this.sd=sd;
		doUpdate();
	}

	
	@Override
	protected void doUpdate() {
		UASProperties config = parentWSResource.getKernel().getAttribute(UASProperties.class);
		String allowed = sd.getProtocols();
		if (allowed==null)
			allowed = config.getValue(UASProperties.SMS_PROTOCOLS);
		
		List<ProtocolType.Enum> list=SMSBaseImpl.parseStorageProtocols(allowed);
		protocols=list.toArray(new ProtocolType.Enum[list.size()]);
		xdoc=new ProtocolDocument[protocols.length];
		for(int i=0;i<protocols.length;i++){
			ProtocolType.Enum protocol= protocols[i];
			ProtocolDocument pd=ProtocolDocument.Factory.newInstance();
			pd.setProtocol(protocol);
			xdoc[i]=pd;
		}
	}

	@Override
	public ProtocolDocument[] getXml() {
		return xdoc;
	}

	/**
	 * returns the protocol array
	 */
	@Override
	public ProtocolType.Enum[] getProperty() {
		return protocols;
	}
}