package de.fzj.unicore.uas.fts;

import org.unigrids.x2006.x04.services.fts.TransferredBytesDocument;

import de.fzj.unicore.wsrflite.impl.ResourceImpl;
import de.fzj.unicore.wsrflite.xmlbeans.ResourceProperty;

public class TransferredBytesResourceProperty extends ResourceProperty<Long>{
	protected static final long serialVersionUID=1L;
	   
	private TransferredBytesDocument[] xdoc;
	private TransferredBytesDocument transferred;
	
	public TransferredBytesResourceProperty(Long l, ResourceImpl inst){
		super(inst);
		setProperty(l);
	}
	
	@Override
	public ResourceProperty<Long> update() throws Exception {
		setProperty(((FileTransferImpl)parentWSResource).getTransferredBytes());
		return this;
	}

	@Override
	public TransferredBytesDocument[] getXml() {
		return xdoc;
	}
	
	@Override
	public void setProperty(Long o) {
		transferred=TransferredBytesDocument.Factory.newInstance();
		transferred.setTransferredBytes(o);
		xdoc=new TransferredBytesDocument[]{transferred};
	}
}
	