package de.fzj.unicore.uas.fts;

import org.unigrids.x2006.x04.services.fts.TransferRateDocument;

import de.fzj.unicore.wsrflite.impl.ResourceImpl;
import de.fzj.unicore.wsrflite.xmlbeans.ResourceProperty;

/**
 * publishes the estimated transfer rate of a server-server transfer
 * in bytes per second (this is not the LIVE rate, but the "aggregate" rate,
 * i.e. it will be constant after the transfer has finished)
 * 
 * @author schuller
 */
public class TransferRateResourceProperty extends ResourceProperty<Long>{
	protected static final long serialVersionUID=1L;
	   
	private TransferRateDocument[] xdoc;
	private TransferRateDocument transferred;
	
	public TransferRateResourceProperty(ResourceImpl inst){
		super(inst);
		setProperty(0l);
	}
	
	@Override
	public ResourceProperty<Long> update() throws Exception {
		setProperty(((ServerToServerFileTransferImpl)parentWSResource).getTransferRate());
		return this;
	}

	@Override
	public TransferRateDocument[] getXml() {
		return xdoc;
	}
	
	@Override
	public void setProperty(Long o) {
		transferred=TransferRateDocument.Factory.newInstance();
		transferred.setTransferRate(o);
		xdoc=new TransferRateDocument[]{transferred};
	}
}
	