package de.fzj.unicore.uas.fts;

import org.unigrids.x2006.x04.services.fts.StatusDocument;
import org.unigrids.x2006.x04.services.fts.StatusType;

import de.fzj.unicore.wsrflite.impl.ResourceImpl;
import de.fzj.unicore.wsrflite.xmlbeans.ResourceProperty;

public class StatusResourceProperty extends ResourceProperty<StatusType>{
	protected static final long serialVersionUID=1L;;

	private StatusDocument[] xdoc;
	private StatusDocument status;

	public StatusResourceProperty(StatusType status, ResourceImpl inst){
		super(inst);
		setProperty(status);
	}

	@Override
	public ResourceProperty<StatusType> update() throws Exception {
		setProperty(((FileTransferImpl)parentWSResource).getStatus());
		return this;
	}

	@Override
	public StatusDocument[] getXml() {
		return xdoc;
	}

	@Override
	public void setProperty(StatusType o) {
		status=StatusDocument.Factory.newInstance();
		status.setStatus(o);
		xdoc=new StatusDocument[]{status};
	}

}
