package de.fzj.unicore.uas.fts;

import org.ggf.schemas.jsdl.x2005.x11.jsdl.SourceDocument;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.SourceTargetType;

import de.fzj.unicore.wsrflite.xmlbeans.ResourceProperty;

public class SourceResourceProperty extends ResourceProperty<SourceTargetType>{
	
	protected static final long serialVersionUID=1L;
	   
	private SourceDocument[] xdoc;
	private SourceDocument source;
	
	public SourceResourceProperty(SourceTargetType stt){
		super(null);
		setProperty(stt);
	}
	
	@Override
	public SourceDocument[] getXml() {
		return xdoc;
	}		
	@Override
	public void setProperty(SourceTargetType stt) {
		source=SourceDocument.Factory.newInstance();
		source.setSource(stt);
		xdoc=new SourceDocument[]{source};
	}

	/**
	 * @return SourceTargetType
	 */
	@Override
	public SourceTargetType getProperty() {
		return source.getSource();
	}
	
}