package de.fzj.unicore.uas.admin;

import de.fzj.unicore.uas.UAS;
import de.fzj.unicore.uas.impl.tss.TargetSystemHomeImpl;
import de.fzj.unicore.uas.xnjs.XNJSFacade;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.xnjs.legacy.LegacyTSI;
import de.fzj.unicore.xnjs.legacy.TSIConnectionFactory;
import de.fzj.unicore.xnjs.simple.LocalTS;
import de.fzj.unicore.xnjs.tsi.TSIFactory;

/**
 * general information and admin operations available via JMX
 */
public class UASAdmin implements UASAdminMBean {

	private final Kernel useKernel;

	public UASAdmin(Kernel useKernel){
		this.useKernel=useKernel;
	}

	@Override
	public String getTSIConnectionStatus(){
		try{
			if(useKernel.getHome(UAS.TSS)==null){
				return "N/A";
			}
			String tsiClass=XNJSFacade.get(null,useKernel).getConfiguration().getProperty(TSIFactory.TSI_TO_USE);
			if(LegacyTSI.class.getName().equals(tsiClass)){
				TSIConnectionFactory tsif=XNJSFacade.get(null,useKernel).getConfiguration().getComponentInstanceOfType(TSIConnectionFactory.class);
				return tsif.getConnectionStatus();
			}
			else if(tsiClass==null || LocalTS.class.getName().equals(tsiClass)){
				return "OK [using embedded TSI]";
			}
		}catch(Exception e){}
		return "N/A";
	}

	@Override
	public String isJobSubmissionEnabled() {
		return String.valueOf(((TargetSystemHomeImpl)useKernel.getHome(UAS.TSS)).isJobSubmissionEnabled());
	}

	@Override
	public void toggleJobSubmissionEnabled() {
		TargetSystemHomeImpl th=(TargetSystemHomeImpl)useKernel.getHome(UAS.TSS);
		boolean enabled=th.isJobSubmissionEnabled();
		th.setJobSubmissionEnabled(!enabled);
	}
}
