package de.fzj.unicore.uas.admin;

import java.util.Map;

import de.fzj.unicore.uas.xnjs.XNJSFacade;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.admin.AdminAction;
import de.fzj.unicore.wsrflite.admin.AdminActionResult;
import de.fzj.unicore.xnjs.ems.Action;
import eu.unicore.util.Log;

/**
 * {@link AdminAction} which prints details about an XNJS action 
 */
public class ShowJobDetails implements AdminAction {

	@Override
	public String getName() {
		return "ShowJobDetails";
	}

	@Override
	public AdminActionResult invoke(Map<String, String> params, Kernel kernel) {
		String requestedID=params.get("jobID");
		//optional xnjs reference
		String xnjsReference=params.get("xnjsReference");
		
		boolean success=true;
		String message = "Job information for "+requestedID;
		if(xnjsReference!=null){
			message+=" on XNJS "+xnjsReference;
		}
		
		StringBuilder info=new StringBuilder();
		try{
			Action a=XNJSFacade.get(xnjsReference, kernel).getAction(requestedID);
			if(a!=null){
				info.append(a.toString());
				info.append("Processing context: ");
				info.append(a.getProcessingContext());
				if(a.getApplicationInfo()!=null){
					info.append("\nApplication Info: ");
					info.append(a.getApplicationInfo());
				}
				info.append("\nJob log: ");
				for(String l: a.getLog()){
					info.append("\n").append(l);
				}
			}
			else{
				info.append("No such job!");
			}
		}catch(Exception ex){
			success=false;
			message=Log.createFaultMessage("Getting info failed", ex);
		}
		AdminActionResult res=new AdminActionResult(success,message);
		
		res.addResult("Info", info.toString());
		
		return res;
	}

	@Override
	public String getDescription() {
		return "parameters: jobID, [xnjsReference]";
	}
}