package de.fzj.unicore.uas;

import org.apache.xmlbeans.XmlObject;
import org.unigrids.services.atomic.types.VersionDocument;

import de.fzj.unicore.wsrflite.Resource;
import de.fzj.unicore.wsrflite.xmlbeans.ResourceProperty;

/**
 * publishes the version of the parent resource 
 */
public class VersionResourceProperty  extends ResourceProperty<Object>{

	private static final long serialVersionUID = 1L;
	
	private final VersionDocument[] xdoc;
	
	public VersionResourceProperty(Resource parent){
		super(parent);
		VersionDocument ver=VersionDocument.Factory.newInstance();
		xdoc=new VersionDocument[]{ver};
		update();
	}
	
	@Override
	public XmlObject[] getXml() {
		return xdoc;
	}
	
	public final VersionResourceProperty update(){
		xdoc[0].setVersion(UAS.getVersion(parentWSResource.getClass()));
		return this;
	}
}
