/*
 * Copyright (c) 2012 ICM Uniwersytet Warszawski All rights reserved.
 * See LICENCE.txt file for licensing information.
 */
package de.fzj.unicore.uas;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

import org.apache.log4j.Logger;

import de.fzj.unicore.uas.impl.sms.DefaultStorageInfoProvider;
import de.fzj.unicore.uas.impl.sms.StorageInfoProvider;

import eu.unicore.util.Log;
import eu.unicore.util.configuration.ConfigurationException;
import eu.unicore.util.configuration.DocumentationReferenceMeta;
import eu.unicore.util.configuration.PropertyMD;

/**
 * This class is used to handle configuration of a particular storage factory. The only difference
 * to configuration of SMS is ability to set SMS factory info provider.
 * <p>
 * Note for documentation generation: an artificial prefix must be manually set, as this class is used
 * many times with different prefixed, determined at runtime.
 * 
 * @author K. Benedyczak
 */
public class SMSFactoryProperties extends SMSProperties {
	
	private static final Logger log = Log.getLogger(Log.SERVICES, SMSFactoryProperties.class);

	public static final String INFO_PROVIDER="infoProviderClass";
	
	@DocumentationReferenceMeta
	public static final Map<String, PropertyMD> META = new HashMap<String, PropertyMD>();
	static {
		META.putAll(SMSProperties.META);
		META.put(INFO_PROVIDER, new PropertyMD(DefaultStorageInfoProvider.class, StorageInfoProvider.class).
				setDescription("(Very) advanced setting, used only in case of SMS Factories. Usually you don't have to bother with it. Allows to change an implementation providing information about storages produced by the SMS factory."));
	}
	
	public SMSFactoryProperties(String prefix, Properties properties) throws ConfigurationException {
		super(prefix, properties, META, log);
	}
}
