package de.fzj.unicore.uas.client;

import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;
import static org.junit.Assert.assertNotNull;

import java.lang.reflect.Field;
import java.lang.reflect.Proxy;

import org.junit.Test;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

import eu.unicore.security.xfireutil.client.ReliableProxy;
import eu.unicore.security.xfireutil.client.ReliableProxy.RetryDecider;
import eu.unicore.util.httpclient.DefaultClientConfiguration;

public class TestUASClient {

	@Test
	public void testVersionCompare(){
		assertTrue(BaseUASClient.compareVersions("1.4.1","1.4.2"));
		assertTrue(BaseUASClient.compareVersions("1.4.1","DEVELOPMENT"));
		assertTrue(BaseUASClient.compareVersions("1.4.1-SNAPSHOT","1.4.2"));
		assertTrue(BaseUASClient.compareVersions("1.4.1","1.4.2-SNAPSHOT"));
		assertFalse(BaseUASClient.compareVersions("1.4.1","1.4.0"));
	}
	
	@Test
	public void testRetrySetup()throws Exception{
		EndpointReferenceType epr=EndpointReferenceType.Factory.newInstance();
		epr.addNewAddress().setStringValue("http://test123");
		BaseUASClient b=new BaseUASClient(epr, new DefaultClientConfiguration());
		ReliableProxy xp=(ReliableProxy)Proxy.getInvocationHandler(b.getLT());
		Field f=xp.getClass().getDeclaredField("retryDecider");
		f.setAccessible(true);
		RetryDecider rd=(RetryDecider)f.get(xp);
		assertNotNull(rd);
	}
}
