package de.fzj.unicore.uas.rns;


import javax.xml.namespace.QName;

import org.ggf.rns.WriteNotPermittedFaultDocument;

/**
 * 
 * @author demuth
 *
 */
public class WriteNotPermittedFault extends RNSFault
{
	private static final long serialVersionUID = -5735519748507658480L;

	public WriteNotPermittedFault(String filename, Throwable t)
	{
		super(buildMessage(filename),t);
		
	}

	public WriteNotPermittedFault(String filename)
	{
		super(buildMessage(filename));
		
	}
	
	public static QName getFaultName()
	{
		return WriteNotPermittedFaultDocument.type.getDocumentElementName();
	}
	
	

	private static String buildMessage(String filename)
	{
		return new StringBuilder("Write not permitted on ").
		append(filename).append(".").toString();
	}
	

}

