package de.fzj.unicore.uas.rns;


import javax.xml.namespace.QName;

import org.ggf.rns.ReadNotPermittedFaultDocument;

/**
 * 
 * @author demuth
 *
 */
public class ReadNotPermittedFault extends RNSFault
{
	private static final long serialVersionUID = -5735519748507658480L;

	public ReadNotPermittedFault(String filename)
	{
		super(buildMessage(filename));
		
	}
	
	public ReadNotPermittedFault(String filename, Throwable t)
	{
		super(buildMessage(filename),t);
		
	}
	
	public static QName getFaultName()
	{
		return ReadNotPermittedFaultDocument.type.getDocumentElementName();
	}

	private static String buildMessage(String filename)
	{
		return new StringBuilder("Read not permitted on ").
		append(filename).append(".").toString();
	}
	

}

