package de.fzj.unicore.uas.rns;

import javax.jws.WebMethod;
import javax.jws.WebService;

import org.ggf.rns.AddRequestDocument;
import org.ggf.rns.AddResponseDocument;
import org.ggf.rns.LookupRequestDocument;
import org.ggf.rns.LookupResponseDocument;
import org.ggf.rns.RemoveRequestDocument;
import org.ggf.rns.RemoveResponseDocument;
import org.ggf.rns.RenameRequestDocument;
import org.ggf.rns.RenameResponseDocument;
import org.ggf.rns.SetMetadataRequestDocument;
import org.ggf.rns.SetMetadataResponseDocument;

import de.fzj.unicore.wsrflite.xmlbeans.BaseFault;

/**
 * RNSPortType.java
 *
 */

@WebService(targetNamespace = "http://schemas.ogf.org/rns/2009/12/rns",
		portName="RNSPortType")
public interface RNSPortType {

	@WebMethod(action = "http://schemas.ogf.org/rns/2009/12/rns/AddRequest")
	public AddResponseDocument add(AddRequestDocument addRequest) throws BaseFault;
	
	@WebMethod(action = "http://schemas.ogf.org/rns/2009/12/rns/LookupRequest")
	public LookupResponseDocument lookup(LookupRequestDocument lookupRequest) throws BaseFault;
	
	@WebMethod(action = "http://schemas.ogf.org/rns/2009/12/rns/RenameRequest")
	public RenameResponseDocument rename(RenameRequestDocument renameRequest) throws BaseFault;
	
	@WebMethod(action = "http://schemas.ogf.org/rns/2009/12/rns/RemoveRequest")
	public RemoveResponseDocument remove(RemoveRequestDocument removeRequest) throws BaseFault;
	
	@WebMethod(action = "http://schemas.ogf.org/rns/2009/12/rns/SetMetadataRequest")
	public SetMetadataResponseDocument setMetadata(SetMetadataRequestDocument setMetadataRequest) throws BaseFault;
}

