package de.fzj.unicore.uas.rns;

import java.util.Calendar;

import javax.xml.namespace.QName;

import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlBeans;
import org.apache.xmlbeans.XmlObject;
import org.codehaus.xfire.annotations.FaultHandlers;
import org.ggf.rns.RNSEntryDoesNotExistFaultDocument;
import org.oasisOpen.docs.wsrf.bf2.BaseFaultDocument;
import org.oasisOpen.docs.wsrf.bf2.BaseFaultType;

import de.fzj.unicore.wsrflite.xmlbeans.BaseFault;

public class RNSFault extends BaseFault{

	private BaseFaultType faultType;
	
	public RNSFault(String message, Throwable cause) {
		super(message, cause, null);
		BaseFaultDocument doc = BaseFaultDocument.Factory.newInstance();
		faultType = doc.addNewBaseFault();
		faultType.setTimestamp(Calendar.getInstance());
		faultType.addNewDescription().setStringValue(getMessage());
	
	}

	public RNSFault(String message) {
		this(message,null);
	}

	public BaseFaultType getFaultInfo() {
		return faultType;
	}

}
