package de.fzj.unicore.uas.rns;


import java.util.Calendar;

import javax.xml.namespace.QName;

import org.ggf.rns.RNSEntryDoesNotExistFaultDocument;
import org.ggf.rns.RNSEntryExistsFaultDocument;
import org.oasisOpen.docs.wsrf.bf2.BaseFaultType;

import de.fzj.unicore.wsrflite.xmlbeans.BaseFault;

/**
 * 
 * @author demuth
 *
 */
public class RNSEntryExistsFault extends RNSFault
{
	private static final long serialVersionUID = -5735519748507658480L;

	
	
	public RNSEntryExistsFault(String filename, Throwable cause) {
		super(buildMessage(filename), cause);
	}

	public RNSEntryExistsFault(String filename) {
		super(buildMessage(filename));
	}

	public static QName getFaultName()
	{
		return RNSEntryExistsFaultDocument.type.getDocumentElementName();
	}

	private static String buildMessage(String filename)
	{
		return new StringBuilder("RNS entry ").
		append(filename).append(" exists already.").toString();
	}
	

}

