package de.fzj.unicore.uas.rns;


import java.util.Calendar;

import javax.xml.namespace.QName;

import org.ggf.rns.RNSEntryDoesNotExistFaultDocument;
import org.ggf.rns.RNSEntryExistsFaultDocument;
import org.ggf.rns.ReadNotPermittedFaultDocument;
import org.oasisOpen.docs.wsrf.bf2.BaseFaultType;

import de.fzj.unicore.wsrflite.xmlbeans.BaseFault;

/**
 * 
 * @author demuth
 *
 */
public class RNSEntryDoesNotExistFault extends RNSFault
{
	private static final long serialVersionUID = -5735519748507658480L;

	public RNSEntryDoesNotExistFault(String filename)
	{
		super(buildMessage(filename));
		
	}
	
	public RNSEntryDoesNotExistFault(String filename, Throwable t)
	{
		super(buildMessage(filename),t);
		
	}
	
	public static QName getFaultName()
	{
		return RNSEntryDoesNotExistFaultDocument.type.getDocumentElementName();
	}
	

	private static String buildMessage(String filename)
	{
		return new StringBuilder("RNS entry ").
		append(filename).append(" does not exist.").toString();
	}
	

}

