package de.fzj.unicore.uas.rns;

import java.lang.reflect.Field;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;

import org.apache.log4j.Logger;
import org.ggf.rns.LookupRequestDocument;
import org.ggf.rns.LookupRequestType;
import org.ggf.rns.LookupResponseDocument;
import org.ggf.rns.RNSEntryResponseType;
import org.ggf.rns.RemoveRequestDocument;
import org.ggf.rns.RemoveRequestType;
import org.ggf.rns.RemoveResponseDocument;
import org.ggf.rns.RemoveResponseType;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

import eu.unicore.security.xfireutil.client.ReliableProxy;
import eu.unicore.security.xfireutil.client.ReliableProxy.RetryDecider;
import eu.unicore.security.xfireutil.client.UnicoreXFireClientFactory;
import eu.unicore.util.Log;
import eu.unicore.util.httpclient.IClientConfiguration;

public class RNSClient {

	private static final Logger logger = Log.getLogger(Log.CLIENT,RNSClient.class);

	private RNSPath path;
	private IClientConfiguration sec;

	protected ReliableProxy.RetryDecider retryDecider;

	public RNSClient(RNSPath path, IClientConfiguration sec) {
		super();
		this.path = path;
		this.sec = sec;
	}


	public RNSPath[] lookup(String... names) throws RNSFault
	{

		LookupRequestDocument doc = LookupRequestDocument.Factory.newInstance();
		LookupRequestType request = doc.addNewLookupRequest();
		if(names != null && names.length > 0)
		{
			request.setEntryNameArray(names);
		}
		try {
			LookupResponseDocument response = makeProxy().lookup(doc);
			RNSEntryResponseType[] entries = response.getLookupResponse().getEntryResponseArray();
			List<RNSPath> result = new ArrayList<RNSPath>();
			for(RNSEntryResponseType entry : entries)
			{
				result.add(new RNSPath(path, entry.getEntryName(), entry.getEndpoint()));
			}
			return result.toArray(new RNSPath[result.size()]);
		} catch (Exception e) {
			throw new RNSFault("Unable to perform lookup operation", e);
		}
	}

	public boolean[] remove(String... names) throws RNSFault, RNSInvalidResultNumberException
	{

		if(names == null || names.length == 0) return new boolean[0];

		RemoveRequestDocument doc = RemoveRequestDocument.Factory.newInstance();
		RemoveRequestType request = doc.addNewRemoveRequest();
		request.setEntryNameArray(names);

		try {
			RemoveResponseDocument responseDoc = makeProxy().remove(doc);
			RemoveResponseType response = responseDoc.getRemoveResponse();
			RNSEntryResponseType[] results = response.getEntryResponseArray();
			if(results.length != names.length) throw new RNSInvalidResultNumberException();
			boolean[] result = new boolean[results.length];
			for(int i = 0; i < results.length; i++)
			{
				boolean success = results[i].getFault() == null;
				result[i] = success;
			}
			return result;
		} catch (RNSFault e) {
			throw e;
		} catch (Exception e) {
			throw new RNSFault("Unable to perform remove operation.", e);
		}
	}

	protected RNSPortType makeProxy() throws Exception{

		EndpointReferenceType epr = path.getEndpointReference();
		RNSPortType proxy=new UnicoreXFireClientFactory(sec).createPlainWSProxy(RNSPortType.class,epr.getAddress().getStringValue());
		configureRetry(proxy);
		return proxy;

	}

	private void configureRetry(Object proxy){
		ReliableProxy xp=(ReliableProxy)Proxy.getInvocationHandler(proxy);
		xp.setRetryDecider(retryDecider);
	}


	/**
	 * set the {@link RetryDecider} that decides whether a failed ws call 
	 * shall be retried
	 * @param retry - the {@link RetryDecider}
	 */
	public void setRetryHandler(RetryDecider retry){
		retryDecider=retry;
		//need to update all our ws proxies
		for(Field f: getClass().getDeclaredFields()){
			try{
				f.setAccessible(true);
				Object obj=f.get(this);
				if(obj==null)continue;
				if(Proxy.isProxyClass(obj.getClass())){
					configureRetry(obj);
				}
			}catch(IllegalAccessException ie){
				Log.logException("Can't reconfigure retry on <"+f.getName()+">", ie,logger);
			}
		}
	}

}
