/*********************************************************************************
 * Copyright (c) 2006 Forschungszentrum Juelich GmbH 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * (1) Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer at the end. Redistributions in
 * binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other
 * materials provided with the distribution.
 * 
 * (2) Neither the name of Forschungszentrum Juelich GmbH nor the names of its 
 * contributors may be used to endorse or promote products derived from this 
 * software without specific prior written permission.
 * 
 * DISCLAIMER
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 ********************************************************************************/
 
package de.fzj.unicore.uas.client;

import java.util.HashMap;

import javax.xml.namespace.QName;

import org.oasisOpen.docs.wsn.b2.SubscribeDocument;
import org.oasisOpen.docs.wsn.b2.SubscribeResponseDocument;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

import de.fzj.unicore.wsrflite.xmlbeans.client.BaseWSRFClient;
import de.fzj.unicore.wsrflite.xmlbeans.wsn.NotificationProducer;
import de.fzj.unicore.wsrflite.xmlbeans.wsn.util.Filters;
import de.fzj.unicore.wsrflite.xmlbeans.wsn.util.SimpleWSNTopicExpression;
import eu.unicore.util.httpclient.IClientConfiguration;

/**
 * simple client for managing notifications (i.e. subscribing, unsubscribing).
 * 
 * @author schuller
 */
public class UASNotificationClient extends BaseUASClient {

	private final EndpointReferenceType consumer;

	private final HashMap <QName,EndpointReferenceType>subscriptions=new HashMap<QName, EndpointReferenceType>();
	
	/**
	 * @param consumer - the EPR of the notification consumer service
	 * @param endpointUrl - the URL of the target service
	 * @param epr - the EPR of the target service
	 * @param sec - the security settings to use
	 */
	public UASNotificationClient(EndpointReferenceType consumer, String endpointUrl, EndpointReferenceType epr, IClientConfiguration sec)throws Exception{
		super(endpointUrl, epr, sec);
		this.consumer=consumer;
	}

	/**
	 * @param consumer - the EPR of the notification consumer service
	 * @param epr - the EPR of the target service
	 * @param sec - the security settings to use
	 */
	public UASNotificationClient(EndpointReferenceType consumer, EndpointReferenceType epr, IClientConfiguration sec)throws Exception{
		this(consumer, epr.getAddress().getStringValue(),epr,sec);
	}

	/**
	 * subscribe to all changes of the resource property defined by the given qname.
	 * @param event QName
	 */
	public void subscribe(QName event)throws Exception{
		subscribe(event, null);
	}
	
	/**
	 * subscribe to "simple" property changes
	 * @param event The QName of the resource property to watch
	 * @param xpath An xpath expression to use as a message filter
	 */
	public void subscribe(QName event, String xpath)throws Exception{
		NotificationProducer np=makeProxy(NotificationProducer.class);
		SubscribeDocument sd=SubscribeDocument.Factory.newInstance();
		sd.addNewSubscribe().addNewFilter().set(new SimpleWSNTopicExpression(event).toXml());
		Filters.addXPathMessageContentFilter(sd.getSubscribe().getFilter(),xpath);

		sd.getSubscribe().setConsumerReference(consumer);
		SubscribeResponseDocument res=np.Subscribe(sd);
		EndpointReferenceType epr=res.getSubscribeResponse().getSubscriptionReference();
		subscriptions.put(event,epr);
	}
	
	public void unsubscribe(QName event)throws Exception{
		EndpointReferenceType sEpr=subscriptions.get(event);
		BaseWSRFClient rlClient=new BaseUASClient(sEpr,getSecurityConfiguration());
		rlClient.destroy();
	}
	

}
