package de.fzj.unicore.uas.client;

import java.math.BigInteger;
import java.util.Calendar;

import org.apache.xmlbeans.XmlObject;
import org.unigrids.services.atomic.types.StatusInfoType;
import org.unigrids.services.atomic.types.StatusType;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

import de.fzj.unicore.uas.Task;
import eu.unicore.util.httpclient.IClientConfiguration;
import eu.unicore.unicore6.task.CancelRequestDocument;
import eu.unicore.unicore6.task.ResultDocument.Result;
import eu.unicore.unicore6.task.SubmissionTimeDocument;
import eu.unicore.unicore6.task.TaskPropertiesDocument;

/**
 * client for talking to a Task service
 * 
 * @author schuller
 */
public class TaskClient extends BaseUASClient {

	private Calendar submissionTime;

	private Integer exitCode;

	public TaskClient(String url, EndpointReferenceType epr, IClientConfiguration sec) throws Exception {
		super(url, epr, sec);
	}

	public TaskClient(EndpointReferenceType epr, IClientConfiguration sec) throws Exception {
		this(epr.getAddress().getStringValue(), epr, sec);
	}

	public TaskPropertiesDocument getResourcePropertiesDocument()throws Exception{
		return TaskPropertiesDocument.Factory.parse(GetResourcePropertyDocument().getGetResourcePropertyDocumentResponse().newInputStream());
	}

	/**
	 * get the Task's result or <code>null</code> if not available
	 * @return
	 * @throws Exception
	 */
	public XmlObject getResult()throws Exception{
		Result result=getResourcePropertiesDocument().getTaskProperties().getResult();
		if(result==null)return null;
		return XmlObject.Factory.parse(result.newXMLStreamReader());
	}
	/**
	 * return the job status
	 * @throws Exception
	 */
	public StatusType.Enum getStatus() throws Exception{
		StatusInfoType s=getResourcePropertiesDocument().getTaskProperties().getStatusInfo();
		return s.getStatus();
	}

	/**
	 * return the exit code of the job
	 * @return the exit code or null if not available
	 */
	public Integer getExitCode()throws Exception{
		if(exitCode==null){
			StatusInfoType sit=getResourcePropertiesDocument().getTaskProperties().getStatusInfo();
			if(sit.isSetExitCode()){
				BigInteger eCode=sit.getExitCode();
				if(eCode!=null)exitCode=eCode.intValue();	
			}
		}
		return exitCode;
	}


	/**
	 * return the progress of the job
	 * @return a value between 0 and 1 or <code>null</code> if progress value not available
	 */
	public Float getProgress()throws Exception{
		if(getResourcePropertiesDocument().getTaskProperties().getStatusInfo().isSetProgress()){
			return getResourcePropertiesDocument().getTaskProperties().getStatusInfo().getProgress();
		}
		return null;
	}

	/**
	 * get the time at which the task was submitted
	 * @return
	 * @throws Exception
	 */
	public Calendar getSubmissionTime()throws Exception{
		if(submissionTime==null)
		{
			submissionTime=SubmissionTimeDocument.Factory.parse(getResourceProperty(Task.RP_SUBMISSION_TIME)).getSubmissionTime();
		}
		return submissionTime;
	}

	public String getStatusMessage()throws Exception{
		return getResourcePropertiesDocument().getTaskProperties().getStatusInfo().getDescription();
	}

	/**
	 * Cancel execution of the task
	 * @throws Exception
	 */
	public void cancel()throws Exception{
		CancelRequestDocument c=CancelRequestDocument.Factory.newInstance();
		c.addNewCancelRequest();
		makeProxy(Task.class).Cancel(c);
	}
}
