package de.fzj.unicore.uas;

import de.fzj.unicore.uas.client.FileTransferClient;
import de.fzj.unicore.uas.client.HttpFileTransferClient;
import de.fzj.unicore.uas.client.RByteIOClient;
import de.fzj.unicore.uas.client.SByteIOClient;
import de.fzj.unicore.uas.client.UFTPFileTransferClient;
import de.fzj.unicore.wsrflite.ClientCapabilities;
import de.fzj.unicore.wsrflite.ClientCapability;

/**
 * advertises client capabilities of the uas-client module
 *
 * @author schuller
 */
public class CoreClientCapabilities implements ClientCapabilities {

	@Override
	public ClientCapability[] getClientCapabilities() {
		return new ClientCapability[]{
				BFTClient,
				UFTPClient,
				RBYTEIOClient,
				SBYTEIOClient,
		};
	}

	/**
	 * specialisation of the {@link ClientCapability} for the file transfer client
	 */
	public static interface FTClientCapability extends ClientCapability{
		
		public String getProtocol();
		
		public Class<? extends FileTransferClient>getImplementation();
	}
	
	private static FTClientCapability BFTClient = new FTClientCapability(){
		public String getProtocol() {
			return "BFT";
		}
		public Class<? extends FileTransferClient> getImplementation() {
			return HttpFileTransferClient.class;
		}
		public Class<?> getInterface() {
			return FileTransferClient.class;
		}
	};

	private static FTClientCapability RBYTEIOClient = new FTClientCapability(){
		public String getProtocol() {
			return "RBYTEIO";
		}
		public Class<? extends FileTransferClient> getImplementation() {
			return RByteIOClient.class;
		}
		public Class<?> getInterface() {
			return FileTransferClient.class;
		}
	};
	
	private static FTClientCapability SBYTEIOClient = new FTClientCapability(){
		public String getProtocol() {
			return "SBYTEIO";
		}
		public Class<? extends FileTransferClient> getImplementation() {
			return SByteIOClient.class;
		}
		public Class<?> getInterface() {
			return FileTransferClient.class;
		}
	};
	
	
	private static ClientCapability UFTPClient=new FTClientCapability(){

		@Override
		public Class<? extends FileTransferClient> getImplementation() {
			return UFTPFileTransferClient.class;
		}

		@Override
		public String getProtocol() {
			return "UFTP";
		}

		@Override
		public Class<?> getInterface() {
			return FileTransferClient.class;
		}

	}; 
}
