/*********************************************************************************
 * Copyright (c) 2007 Forschungszentrum Juelich GmbH 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * (1) Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer at the end. Redistributions in
 * binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other
 * materials provided with the distribution.
 * 
 * (2) Neither the name of Forschungszentrum Juelich GmbH nor the names of its 
 * contributors may be used to endorse or promote products derived from this 
 * software without specific prior written permission.
 * 
 * DISCLAIMER
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 ********************************************************************************/

package de.fzj.unicore.cisprovider;

import javax.jws.WebMethod;
import javax.jws.WebService;
import javax.xml.namespace.QName;

import de.fzj.unicore.cisprovider.xmlbeans.GetGlueInfoRequestDocument;
import de.fzj.unicore.cisprovider.xmlbeans.GetGlueInfoResponseDocument;
import de.fzj.unicore.cisprovider.xmlbeans.GetInfoRequestDocument;
import de.fzj.unicore.cisprovider.xmlbeans.GetInfoResponseDocument;
import de.fzj.unicore.cisprovider.xmlbeans.GetServiceInfoRequestDocument;
import de.fzj.unicore.cisprovider.xmlbeans.GetServiceInfoResponseDocument;
import de.fzj.unicore.wsrflite.xmlbeans.BaseFault;
import eu.unicore.security.OperationType;
import eu.unicore.security.SEIOperationType;

/**
 * Query information from this provider
 */
@WebService(targetNamespace=CISInfoProvider.NAMESPACE, portName=CISInfoProvider.SERVICENAME)
public interface CISInfoProvider {

	public static String NAMESPACE="http://www.unicore.eu/unicore6/cis/infoprovider";
	public static String SERVICENAME="CISInfoProvider";
	public static QName PORTTYPE=new QName(NAMESPACE,SERVICENAME);
	
	@WebMethod(action=NAMESPACE+"/GetInfoRequest")
	@SEIOperationType(OperationType.read)
	public GetInfoResponseDocument getInfo(GetInfoRequestDocument request);
	
	@WebMethod(action=NAMESPACE+"/GetGlueInfoRequest")
	@SEIOperationType(OperationType.read)
	public GetGlueInfoResponseDocument getGlueInfo(GetGlueInfoRequestDocument req) throws BaseFault;
	
	@WebMethod(action=NAMESPACE+"/GetServiceInfoRequest")
	@SEIOperationType(OperationType.read)
	public GetServiceInfoResponseDocument getServiceInfo(GetServiceInfoRequestDocument req) throws BaseFault;
}
