#!/bin/bash

#
# Startup script for UNICORE Registry
# (RPM version)

#
# PID file
#
PID=/var/run/unicore/registry.pid

#
# Startup log
#
STARTLOG=/var/log/unicore/registry/registry-startup.log

#
# Installation Directory
#
dir=`dirname $0`
if [ "$dir" != "." ]
then
  INST=`dirname $dir`
else
  pwd | grep -e 'bin$' > /dev/null
  if [ $? = 0 ]
  then
    INST=".."
  else
    INST=`dirname $dir`
  fi
fi

INST=${INST:-.}

#
# Alternatively specify the installation dir here
#
INST=/etc/unicore/registry


cd $INST

#
# Location of jar files
#
LIB=/usr/share/unicore/registry/lib

#
# check whether the server might be already running
#
if [ -e $PID ] 
 then 
  if [ -d /proc/$(cat $PID) ]
   then
     echo "A UNICORE Registry instance may be already running with process id "$(cat $PID)
     echo "If this is not the case, delete the file $INST/$PID and re-run this script"
     exit 1
   fi
fi

#
# Java command 
#
JAVA="java"


#
# Options to the Java VM
#

# logfile
OPTS=$OPTS" -Djava.util.logging.config.file=logging.properties"
OPTS=$OPTS" -Dlog4j.configuration=logging.properties"

# set this one if you have ssl problems and need debug info
#OPTS=$OPTS" -Djavax.net.debug=ssl,handshake"

#
# enable JMX (use jconsole to connect)
#
#OPTS=$OPTS" -Dcom.sun.management.jmxremote"
#enable JMX remote access protected by username/password
#OPTS=$OPTS" -Dcom.sun.management.jmxremote.port=9128 -Dcom.sun.management.jmxremote.authenticate=true"
#OPTS=$OPTS" -Dcom.sun.management.jmxremote.ssl=false"
#OPTS=$OPTS" -Dcom.sun.management.jmxremote.password.file=jmxremote.password"

#
#make sure jmx password file is owner read-only to avoid startup problems
chmod go-rw jmxremote.password

#
# Memory for the VM
#
MEM=-Xmx128m

#
# setup classpath
#
CP=.$(cd / ; find "$LIB" -name "*.jar" -exec printf ":{}" \;)

#
# setup endorsed directory
#
DEFS="-Djava.endorsed.dirs=${LIB}/endorsed"

PARAM=$*
if [ "$PARAM" = "" ]
then
  PARAM=uas.config
fi

#
# go
#

CLASSPATH=$CP ; export CLASSPATH

nohup $JAVA ${MEM} ${OPTS} ${DEFS} de.fzj.unicore.wsrflite.USEContainer ${PARAM} REGISTRY > $STARTLOG 2>&1  & echo $! > $PID

echo "UNICORE Registry starting"



