package de.fzj.unicore.bes.test;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

import java.io.File;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Set;

import org.apache.commons.io.FileUtils;
import org.ggf.schemas.bes.x2006.x08.besFactory.ActivityDocumentType;
import org.ggf.schemas.bes.x2006.x08.besFactory.CreateActivityDocument;
import org.ggf.schemas.bes.x2006.x08.besFactory.CreateActivityType;
import org.ggf.schemas.bes.x2006.x08.besFactory.GetActivityDocumentResponseType;
import org.ggf.schemas.bes.x2006.x08.besFactory.GetActivityDocumentsDocument;
import org.ggf.schemas.bes.x2006.x08.besFactory.GetActivityDocumentsResponseDocument;
import org.ggf.schemas.bes.x2006.x08.besFactory.GetActivityDocumentsType;
import org.ggf.schemas.bes.x2006.x08.besFactory.GetActivityStatusResponseType;
import org.ggf.schemas.bes.x2006.x08.besFactory.GetActivityStatusesDocument;
import org.ggf.schemas.bes.x2006.x08.besFactory.GetActivityStatusesResponseDocument;
import org.ggf.schemas.bes.x2006.x08.besFactory.GetActivityStatusesType;
import org.ggf.schemas.bes.x2006.x08.besFactory.TerminateActivitiesDocument;
import org.ggf.schemas.bes.x2006.x08.besFactory.TerminateActivitiesResponseDocument;
import org.ggf.schemas.bes.x2006.x08.besFactory.TerminateActivitiesType;
import org.ggf.schemas.bes.x2006.x08.besFactory.TerminateActivityResponseType;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.oasisOpen.docs.wsrf.rl2.TerminationTimeDocument.TerminationTime;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

import de.fzj.unicore.bes.BES;
import de.fzj.unicore.bes.BESFactory;
import de.fzj.unicore.bes.client.FactoryClient;
import de.fzj.unicore.bes.functional.DateJSDL;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.utils.WSServerUtilities;


public class TestFactoryVectorOperations {
	
	private static FactoryClient factoryClient = null;
	private static final int NUM_ACTIVITIES = 20;  
	
	static Kernel kernel;
	
	@BeforeClass
	public static void startServer() throws Exception {
		FileUtils.deleteQuietly(new File("target","data"));
		
		EmbeddedServerStartup.serverStartup();
		kernel=EmbeddedServerStartup.getKernel();
		
		String BESUrl = EmbeddedServerStartup.getServerUrl()+BES.BF+"?res=default_bes_factory";
		EndpointReferenceType besEPR = EndpointReferenceType.Factory.newInstance();
		besEPR.addNewAddress().setStringValue(BESUrl);
		factoryClient = new FactoryClient(besEPR,kernel.getClientConfiguration());
		
	}
	
	private EndpointReferenceType createNewActivityInstance() throws Exception { 
		CreateActivityDocument reqDoc = CreateActivityDocument.Factory.newInstance();
		CreateActivityType reqType = reqDoc.addNewCreateActivity();
		ActivityDocumentType activityDoc = reqType.addNewActivityDocument();
		TerminationTime tt = TerminationTime.Factory.newInstance();
		Calendar c = new GregorianCalendar();
		c.add(Calendar.MONTH, 2);
		tt.setCalendarValue(c);
		activityDoc.setTerminationTime(tt);
		activityDoc.setJobDefinition(new DateJSDL().getJSDL().getJobDefinition());
		return factoryClient.createActivity(reqDoc).getCreateActivityResponse().getActivityIdentifier();
	}
	
	private Set<EndpointReferenceType> createRealAndFakeEPRs(String prefix) throws Exception{
		Set<EndpointReferenceType> eprSet = new HashSet<EndpointReferenceType>();
		int c = 0;
		for (int i = 0; i < NUM_ACTIVITIES; i++) {
			if((i%2)==0){
				eprSet.add(createNewActivityInstance());
			}
			else {
				eprSet.add(WSServerUtilities.makeEPR(BES.BF, prefix+"-"+c, kernel));
				++c;
			}
		}
		return eprSet;
	}
	
	@AfterClass
	public static void stopServer(){
		kernel.shutdown();
	}

	
	@Test
	public void testGetActivityDocuments() throws Exception{
		GetActivityDocumentsDocument reqDoc = GetActivityDocumentsDocument.Factory
		.newInstance();

		GetActivityDocumentsType reqType = reqDoc.addNewGetActivityDocuments();
		Set<EndpointReferenceType> eprSet = createRealAndFakeEPRs("fakedoc");
		reqType.setActivityIdentifierArray(eprSet.toArray(new EndpointReferenceType[eprSet.size()]));
		GetActivityDocumentsResponseDocument getActResDoc = factoryClient.getActivityDocuments(reqDoc);
		GetActivityDocumentResponseType[] array = getActResDoc.getGetActivityDocumentsResponse().getResponseArray();
		assertEquals(array.length,eprSet.size());
		
		for (int i = 0; i < array.length; i++) {
			if(WSServerUtilities.extractResourceID(array[i].getActivityIdentifier()).startsWith("fakedoc")){
				assertNotNull(array[i].getFault());
				assertEquals(array[i].getFault().getFaultcode(),BESFactory.UnknownActivityIdentifierFaultNS);
			}
		}
		
	}
	
	@Test
	public void testTerminateActivities() throws Exception{
		TerminateActivitiesDocument tActDoc = TerminateActivitiesDocument.Factory.newInstance();
		TerminateActivitiesType tActType = tActDoc.addNewTerminateActivities();
		Set<EndpointReferenceType> eprSet = createRealAndFakeEPRs("faketerm");
		tActType.setActivityIdentifierArray(eprSet.toArray(new EndpointReferenceType[eprSet.size()]));
		TerminateActivitiesResponseDocument terminateActivityResponseDoc = factoryClient.terminateActivities(tActDoc);
		TerminateActivityResponseType[] terminatActivityResponseArray = terminateActivityResponseDoc.getTerminateActivitiesResponse().getResponseArray();
		assertEquals(tActType.getActivityIdentifierArray().length, terminatActivityResponseArray.length);
		for (int i = 0; i < terminatActivityResponseArray.length; i++) {
			if(WSServerUtilities.extractResourceID(terminatActivityResponseArray[i].getActivityIdentifier()).startsWith("faketerm")){
				assertNotNull(terminatActivityResponseArray[i].getFault());
				assertEquals(terminatActivityResponseArray[i].getFault().getFaultcode(),BESFactory.UnknownActivityIdentifierFaultNS);
			}
		}
	}

	@Test
	public void testGetActivityStatuses() throws Exception{
		GetActivityStatusesDocument gStatsDoc = GetActivityStatusesDocument.Factory.newInstance();
		GetActivityStatusesType gStatsType = gStatsDoc.addNewGetActivityStatuses();
		Set<EndpointReferenceType> eprSet = createRealAndFakeEPRs("fakestat");
		gStatsType.setActivityIdentifierArray(eprSet.toArray(new EndpointReferenceType[eprSet.size()]));
		GetActivityStatusesResponseDocument getActResDoc = factoryClient.getActivityStatuses(gStatsDoc);
		GetActivityStatusResponseType[] array = getActResDoc.getGetActivityStatusesResponse().getResponseArray();
		assertEquals(array.length,eprSet.size());
		for (int i = 0; i < array.length; i++) {
			if(WSServerUtilities.extractResourceID(array[i].getActivityIdentifier()).startsWith("fakestat")){
				assertNotNull(array[i].getFault());
				assertEquals(array[i].getFault().getFaultcode(),BESFactory.UnknownActivityIdentifierFaultNS);
			}
		}
	}

	@Test
	public void testWithNullVector() throws Exception{
		GetActivityStatusesDocument gStatsDoc = GetActivityStatusesDocument.Factory.newInstance();
		GetActivityStatusesType gStatsType = gStatsDoc.addNewGetActivityStatuses();
		createRealAndFakeEPRs("fakestat");
		gStatsType.setActivityIdentifierArray(null);
		GetActivityStatusesResponseDocument getActResDoc = factoryClient.getActivityStatuses(gStatsDoc);
		GetActivityStatusResponseType[] array = getActResDoc.getGetActivityStatusesResponse().getResponseArray();
		assertNotNull(getActResDoc);
		assertNotNull(array);
	}
}





