package de.fzj.unicore.bes.test;



import static org.junit.Assert.assertTrue;
import static org.junit.Assert.fail;

import java.io.File;

import javax.xml.namespace.QName;

import org.apache.commons.io.FileUtils;
import org.ggf.schemas.bes.x2006.x08.besFactory.ActivityStateEnumeration;
import org.junit.BeforeClass;
import org.junit.Test;

import de.fzj.unicore.bes.activity.rp.StatusRP;
import de.fzj.unicore.bes.factory.rp.BESExtensionRP;
import de.fzj.unicore.bes.factory.rp.IsAcceptingNewActivitiesRP;
import de.fzj.unicore.bes.factory.rp.LocalResourceManagerTypeRP;
import de.fzj.unicore.bes.factory.rp.NamingProfileRP;
import de.fzj.unicore.bes.functional.DateJSDL;
import de.fzj.unicore.uas.UAS;
import de.fzj.unicore.uas.xnjs.XNJSFacade;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.Resource;
import de.fzj.unicore.wsrflite.xmlbeans.ResourceProperty;
import de.fzj.unicore.wsrflite.xmlbeans.impl.WSResourceImpl;
import de.fzj.unicore.xnjs.ems.Action;
import de.fzj.unicore.xnjs.ems.ActionStatus;

public class TestFactoryRP{
	
	@BeforeClass
	public static void init(){
		FileUtils.deleteQuietly(new File("target","data"));
	}

	
	@Test
	public void testSupportedExtensions(){
		BESExtensionRP besExt;
		StringBuilder sb = new StringBuilder();
		
		for (int i = 0; i < 5; i++)	sb.append("ext:"+i+" ");
			
		besExt = new BESExtensionRP(sb.toString());
		assertTrue(besExt.getXml().length == 5);
		}
	
	@Test
	public void testIsAcceptingNewActivitiesRP(){
		IsAcceptingNewActivitiesRP arp = new IsAcceptingNewActivitiesRP(false);
		assertTrue(matchRPValue(arp, "false"));
	}
	
	@Test
	public void testStatusRP() throws Exception{
		UAS uas = new UAS("src/test/resources/uas.config");
	        Kernel kernel = uas.getKernel();
		XNJSFacade xnjs = XNJSFacade.get(null,kernel);
		try {
			Action a = xnjs.makeAction(new DateJSDL().getJSDL());
			a.getProcessingContext().put(Action.AUTO_SUBMIT,"true");
			String actionId = (String)xnjs.getManager().add(a, null);
			StatusRP stat = new StatusRP(createMockResource(kernel), null, actionId);
			while (xnjs.getAction(actionId).getStatus()!=ActionStatus.DONE){
				Thread.sleep(1000);
				continue;
			}
			assertTrue(stat.update().getXml()[0].getActivityStatus().getState() == ActivityStateEnumeration.FINISHED);
			xnjs.shutdown();
		} catch (Exception e) {
			fail();
		}
	}
	
	@Test
	public void testLRMSType(){
		LocalResourceManagerTypeRP lrmsType = new LocalResourceManagerTypeRP("torque");
		assertTrue(matchRPValue(lrmsType, "torque"));
	}
	
	@Test
	public void testNamingProfile(){
		NamingProfileRP nrp = new NamingProfileRP("ws-addr");
		assertTrue(matchRPValue(nrp, "ws-addr"));
	}
	
	
	
	private boolean matchRPValue(ResourceProperty<?> rp, String value){
		boolean match = false;
		if(rp.getNumberOfElements() == 1)
			match = rp.getXml()[0].getDomNode().getFirstChild().getFirstChild().getNodeValue().equals(value);
		return match;
	}
	
	
    
	private Resource createMockResource(Kernel kernel){
		WSResourceImpl wsr=new WSResourceImpl() {
			@Override
			public QName getResourcePropertyDocumentQName() {
				return null;
			}
		};
		wsr.setKernel(kernel);
		return wsr;
	}
}
