package de.fzj.unicore.bes.test;

import static org.junit.Assert.*;

import java.io.File;
import java.util.Calendar;
import java.util.GregorianCalendar;


import org.apache.commons.io.FileUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.ggf.schemas.bes.x2006.x08.besFactory.ActivityDocumentType;
import org.ggf.schemas.bes.x2006.x08.besFactory.ActivityStateEnumeration;
import org.ggf.schemas.bes.x2006.x08.besFactory.ActivityStatusType;
import org.ggf.schemas.bes.x2006.x08.besFactory.CreateActivityDocument;
import org.ggf.schemas.bes.x2006.x08.besFactory.CreateActivityResponseDocument;
import org.ggf.schemas.bes.x2006.x08.besFactory.CreateActivityType;
import org.ggf.schemas.bes.x2006.x08.besFactory.GetFactoryAttributesDocumentDocument1;
import org.ggf.schemas.bes.x2006.x08.besFactory.GetFactoryAttributesDocumentResponseDocument;
import org.ggf.schemas.bes.x2006.x08.besFactory.GetFactoryAttributesDocumentType;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.oasisOpen.docs.wsrf.rl2.TerminationTimeDocument.TerminationTime;
import org.oasisOpen.docs.wsrf.rp2.GetResourcePropertyDocumentDocument1;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

import de.fzj.unicore.bes.BES;
import de.fzj.unicore.bes.client.ActivityClient;
import de.fzj.unicore.bes.client.FactoryClient;
import de.fzj.unicore.bes.functional.DateJSDL;
import de.fzj.unicore.bes.util.ActivityUtils;
import de.fzj.unicore.bes.util.BESUtils;
import de.fzj.unicore.uas.util.LogUtil;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.xmlbeans.client.BaseWSRFClient;

public class TestEmbedded {

    private static final Logger logger = LogUtil.getLogger(LogUtil.SERVICES, TestEmbedded.class);
    protected static FactoryClient factoryClient = null;
    
    protected static Kernel kernel;
    
    @BeforeClass
    public static void startServer() throws Exception {
        FileUtils.deleteQuietly(new File("target", "data"));
        
        EmbeddedServerStartup.serverStartup();
        kernel=EmbeddedServerStartup.getKernel();
        	
        String BESUrl = EmbeddedServerStartup.getServerUrl() + BES.BF + "?res=default_bes_factory";
        EndpointReferenceType besEPR = EndpointReferenceType.Factory.newInstance();
        besEPR.addNewAddress().setStringValue(BESUrl);
        factoryClient = new FactoryClient(besEPR, kernel.getClientConfiguration());
    }

    @Test
    public void testCreateActivity() throws Exception {
        CreateActivityDocument reqDoc = CreateActivityDocument.Factory.newInstance();
        CreateActivityType reqType = reqDoc.addNewCreateActivity();
        ActivityDocumentType activityDoc = reqType.addNewActivityDocument();
        TerminationTime tt = TerminationTime.Factory.newInstance();
        Calendar c = new GregorianCalendar();
        c.add(Calendar.MONTH, 2);
        tt.setCalendarValue(c);
        activityDoc.setTerminationTime(tt);
        activityDoc.setJobDefinition(new DateJSDL().getJSDL().getJobDefinition());

        CreateActivityResponseDocument response = factoryClient.createActivity(reqDoc);
        logger.debug(response.toString());

        assertTrue(response.toString().contains("ActivityIdentifier"));
        ActivityClient client = new ActivityClient(EmbeddedServerStartup.getServerUrl() + BES.BA,
                response.getCreateActivityResponse().getActivityIdentifier(),
                kernel.getClientConfiguration());

        assertTrue(client.getResourcePropertyDocument().contains("FactoryReference"));
       
        String finalState=client.waitUntilDone(5000);
        assertEquals("Finished", finalState);

        final int N = 5;
        for (int i = 0; i < 5; i++) {
            factoryClient.createActivity(reqDoc);
        }

        assertTrue(factoryClient.getTotalNumberOfActivities() >= N);

    }

    @Test
    public void testFactoryResourcePropertyDocument() throws Exception {
        GetResourcePropertyDocumentDocument1 reqDoc = GetResourcePropertyDocumentDocument1.Factory.newInstance();
        reqDoc.addNewGetResourcePropertyDocument();
        assertTrue(factoryClient.getResourcePropertyDocument().toString().contains("CommonName"));
    }

    @Test
    public void testGlueAttributesRP() throws Exception {

        GetFactoryAttributesDocumentDocument1 factoryDoc = GetFactoryAttributesDocumentDocument1.Factory.newInstance();
        factoryDoc.addNewGetFactoryAttributesDocument();

        GetFactoryAttributesDocumentResponseDocument respDoc = factoryClient.getFactoryAttributesDocument();
        String pathExpression = "$this//*:ComputingEndpoint/*:InterfaceName";
        System.out.println(respDoc);
        assertTrue(respDoc.selectPath(pathExpression)[0].toString().contains("BESFactory"));
    }

    @Test
    public void testWSRFDestroy() throws Exception {
    	Logger.getLogger("unicore.security.SecurityManager").setLevel(Level.DEBUG);
        CreateActivityDocument reqDoc = CreateActivityDocument.Factory.newInstance();
        CreateActivityType reqType = reqDoc.addNewCreateActivity();
        ActivityDocumentType activityDoc = reqType.addNewActivityDocument();
        TerminationTime tt = TerminationTime.Factory.newInstance();
        Calendar c = new GregorianCalendar();
        c.add(Calendar.MONTH, 2);
        tt.setCalendarValue(c);

        activityDoc.setTerminationTime(tt);
        activityDoc.setJobDefinition(new DateJSDL().getJSDL().getJobDefinition());

        final int ACTIVITY_NUM = 10;

        EndpointReferenceType[] eprArray = new EndpointReferenceType[ACTIVITY_NUM];

        for (int i = 0; i < ACTIVITY_NUM; i++) {
            CreateActivityResponseDocument response = factoryClient.createActivity(reqDoc);
            eprArray[i] = response.getCreateActivityResponse().getActivityIdentifier();

        }

        // take any activity and destroy it
        logger.debug("Deleting activity: " + eprArray[1].getAddress().getStringValue());

        BaseWSRFClient wsrfClient = new BaseWSRFClient(eprArray[1], kernel.getClientConfiguration());
        wsrfClient.destroy();

        GetFactoryAttributesDocumentDocument1 req = GetFactoryAttributesDocumentDocument1.Factory.newInstance();
        req.addNewGetFactoryAttributesDocument();

        GetFactoryAttributesDocumentResponseDocument res = factoryClient.getFactoryAttributesDocument();
        EndpointReferenceType[] eprCArray = res.getGetFactoryAttributesDocumentResponse().getFactoryResourceAttributesDocument().getActivityReferenceArray();

        for (int i = 0; i < eprCArray.length; i++) {
            assertFalse(eprCArray[i].getAddress().getStringValue().equals(eprArray[1].getAddress().getStringValue()));
        }
        logger.debug("Deleted activity: " + eprArray[1].getAddress().getStringValue() + " not listed in BESFactory attributes");
    }

    @AfterClass
    public static void stopServer() {
    	kernel.shutdown();
    }

    @Test
    public void testWrongJsdl() throws Exception {

        CreateActivityDocument reqDoc = CreateActivityDocument.Factory.newInstance();
        CreateActivityType reqType = reqDoc.addNewCreateActivity();
        ActivityDocumentType activityDoc = reqType.addNewActivityDocument();
        TerminationTime tt = TerminationTime.Factory.newInstance();
        Calendar c = new GregorianCalendar();
        c.add(Calendar.MONTH, 2);
        tt.setCalendarValue(c);
        activityDoc.setTerminationTime(tt);

        activityDoc.setJobDefinition(BESUtils.getJSDLFromFile("src/test/resources/jsdl/wrongjsdl.xml").getJobDefinition());

        CreateActivityResponseDocument response = factoryClient.createActivity(reqDoc);
        logger.debug(response.toString());

        ActivityClient client = new ActivityClient(EmbeddedServerStartup.getServerUrl() + BES.BA,
                response.getCreateActivityResponse().getActivityIdentifier(),
                kernel.getClientConfiguration());

        client.waitUntilDone(5000);
        
        String s = factoryClient.getActivityStatusAsXML(response.getCreateActivityResponse().getActivityIdentifier());
        ActivityStatusType asType = ActivityStatusType.Factory.parse(s);
        assertTrue(asType.getState() == ActivityStateEnumeration.FAILED);
        assertNotNull(asType.getFault().getFaultcode());
        assertNotNull(asType.getFault().getFaultstring());

    }

    @Test
    public void testBasicActivityFilter() throws Exception {
        CreateActivityDocument reqDoc = CreateActivityDocument.Factory.newInstance();
        CreateActivityType reqType = reqDoc.addNewCreateActivity();
        ActivityDocumentType activityDoc = reqType.addNewActivityDocument();
        TerminationTime tt = TerminationTime.Factory.newInstance();
        Calendar c = new GregorianCalendar();
        c.add(Calendar.MONTH, 2);
        tt.setCalendarValue(c);

        activityDoc.setTerminationTime(tt);
        activityDoc.setJobDefinition(new DateJSDL().getJSDL().getJobDefinition());
        factoryClient.createActivity(reqDoc);

        GetFactoryAttributesDocumentResponseDocument responseAtt = null;
        GetFactoryAttributesDocumentDocument1 reqAtt = GetFactoryAttributesDocumentDocument1.Factory.newInstance();
        GetFactoryAttributesDocumentType reqAttType = reqAtt.addNewGetFactoryAttributesDocument();

        reqAttType.set(ActivityUtils.filterOnlyActivityBeans());
        responseAtt = factoryClient.getFactoryAttributesDocument(reqAtt);
        assertTrue(responseAtt.getGetFactoryAttributesDocumentResponse().getFactoryResourceAttributesDocument().getActivityReferenceArray().length > 0);

        reqAttType.set(ActivityUtils.filterActivityAndResources());
        responseAtt = factoryClient.getFactoryAttributesDocument(reqAtt);
        assertTrue(responseAtt.getGetFactoryAttributesDocumentResponse().getFactoryResourceAttributesDocument().getActivityReferenceArray().length > 0);

        reqAttType.set(ActivityUtils.filterNoneBeans());
        responseAtt = factoryClient.getFactoryAttributesDocument(reqAtt);
        assertEquals(responseAtt.getGetFactoryAttributesDocumentResponse().getFactoryResourceAttributesDocument().getActivityReferenceArray().length, 0);

        reqAttType.set(ActivityUtils.filterOnlyResourceBeans());
        responseAtt = factoryClient.getFactoryAttributesDocument(reqAtt);
        assertEquals(responseAtt.getGetFactoryAttributesDocumentResponse().getFactoryResourceAttributesDocument().getActivityReferenceArray().length, 0);


    }
}
