package de.fzj.unicore.bes.test;

import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import javax.xml.namespace.QName;

import org.ggf.schemas.jsdl.x2005.x11.jsdl.JobDefinitionDocument;
import org.junit.Test;
import org.xmlsoap.schemas.soap.envelope.Fault;

import de.fzj.unicore.bes.util.BESUtils;


public class TestBESUtils{
	@Test
	public void testSOAP11FaultBuilder() {
		Fault fault = BESUtils.buildSOAP11Fault(new QName("SampleFault"), "Sample SOAP Fault");
		assertFalse(!fault.getFaultcode().getLocalPart().equals("SampleFault"));
		assertTrue(fault.getFaultstring().contains("SOAP"));
	}

	@Test
	public void testGetJSDLFile() throws Exception{
			JobDefinitionDocument jobDoc = BESUtils.getJSDLFromFile("src/test/resources/jsdl/jsdlinstance.xml");
			assertNotNull(jobDoc.getJobDefinition().getJobDescription().getApplication().getApplicationName());
	}
	
}
