package de.fzj.unicore.bes.test;

import static org.junit.Assert.*;

import java.io.File;

import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.ggf.schemas.bes.x2006.x08.besFactory.ActivityDocumentDocument1;
import org.ggf.schemas.bes.x2006.x08.besFactory.CreateActivityDocument;
import org.ggf.schemas.bes.x2006.x08.besFactory.CreateActivityResponseDocument;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.JobDefinitionDocument;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

import de.fzj.unicore.bes.BES;
import de.fzj.unicore.bes.client.FactoryClient;
import de.fzj.unicore.bes.client.ManagementClient;
import de.fzj.unicore.bes.faults.NotAcceptingNewActivitiesFault;
import de.fzj.unicore.bes.functional.DateJSDL;
import de.fzj.unicore.uas.util.LogUtil;
import de.fzj.unicore.wsrflite.Kernel;

public class TestBESManagement{
	
		private static final Logger logger=LogUtil.getLogger(LogUtil.SERVICES, TestBESManagement.class);
		protected static FactoryClient factoryClient = null;
		protected static ManagementClient mgmtClient = null;
		protected static Kernel kernel;
		
		@BeforeClass
		public static void startServer() throws Exception {
			FileUtils.deleteQuietly(new File("target","data"));
			EmbeddedServerStartup.serverStartup();
			kernel=EmbeddedServerStartup.getKernel();
			String BESUrl = EmbeddedServerStartup.getServerUrl()+BES.BF+"?res=default_bes_factory";
			EndpointReferenceType besEPR = EndpointReferenceType.Factory.newInstance();
			besEPR.addNewAddress().setStringValue(BESUrl);
			factoryClient = new FactoryClient(besEPR,kernel.getClientConfiguration());
			mgmtClient = new ManagementClient(EmbeddedServerStartup.getServerUrl() + BES.BM, 
					kernel.getClientConfiguration());
		}
		
		@Test
		public void submitActivities() {

			JobDefinitionDocument jobDoc = new DateJSDL().getJSDL();
			ActivityDocumentDocument1 actDoc = ActivityDocumentDocument1.Factory.newInstance();
			actDoc.addNewActivityDocument().setJobDefinition(jobDoc.getJobDefinition());
			CreateActivityDocument caDoc = CreateActivityDocument.Factory.newInstance();
			caDoc.addNewCreateActivity().setActivityDocument(actDoc.getActivityDocument());

			try {
				CreateActivityResponseDocument cresDoc = factoryClient.createActivity(caDoc);
				logger.debug(cresDoc);
				disableActivitySubmission();
			} catch (Exception e1) {
				fail();
			}
			boolean commandEnforced = false;
			try {
				factoryClient.createActivity(caDoc);
			} 
			catch (NotAcceptingNewActivitiesFault e) {
				commandEnforced = true;
				assertTrue("BES is not accepting new activities", true);
			} 
			catch (Exception e) {
				fail();
			} 
			assertTrue("BESFactory must not be accepting activities.",commandEnforced);
			try {
				enableActivitySubmission();
				CreateActivityResponseDocument cresDoc = factoryClient.createActivity(caDoc);
				assertNotNull(cresDoc.getCreateActivityResponse().getActivityIdentifier());
			} catch (Exception e) {
				fail();
			}
		}
		
		private void enableActivitySubmission() throws Exception{
			mgmtClient.startAcceptingNewActivities();
		}
		
		private void disableActivitySubmission() throws Exception{
			mgmtClient.stopAcceptingNewActivities();
		}
		
		@AfterClass
		public static void stopServer(){
			kernel.shutdown();
		}
		
	}

