package de.fzj.unicore.bes.test;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import java.io.File;
import java.util.HashMap;
import java.util.Map;

import org.apache.commons.io.FileUtils;
import org.junit.BeforeClass;
import org.junit.Test;

import de.fzj.unicore.bes.impl.management.BESFactoryAdmin;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.admin.AdminAction;
import de.fzj.unicore.wsrflite.admin.AdminActionResult;

public class TestBESFactoryAdmin {

	static Kernel kernel;
	
    @BeforeClass
    public static void startServer() throws Exception {
        FileUtils.deleteQuietly(new File("target", "data"));
        EmbeddedServerStartup.serverStartup();
        kernel=EmbeddedServerStartup.getKernel();
    }

    
	
    @Test
    public void testBESAdminActionLoader() throws Exception{
		Map<String,AdminAction> act=kernel.getAdminActions();
		assertNotNull(act);
		AdminAction adminAction=act.get("ToggleBESJobSubmission");
		assertNotNull(adminAction);
		assertEquals("ToggleBESJobSubmission", adminAction.getName());
		Map<String,String>params=new HashMap<String, String>();
		params.put("message", "Toggle BES Job Submission");
		AdminActionResult result=adminAction.invoke(params, kernel);
		assertTrue(result.successful());
		assertTrue(result.getMessage().contains("disabled"));
    }
    
    @Test
    public void testBESFactoryAdminMBean() throws Exception{
    	BESFactoryAdmin besAdmin = new BESFactoryAdmin(kernel);
    	String submissionFlag = besAdmin.isJobSubmissionEnabled();
    	assertNotNull(submissionFlag);
    	
    	boolean submissionFlagBool = Boolean.parseBoolean(submissionFlag);
    	if(submissionFlagBool) {
    		besAdmin.toggleJobSubmissionEnabled();
    		assertFalse(Boolean.parseBoolean(besAdmin.isJobSubmissionEnabled()));
    	}
    	else {
    		besAdmin.toggleJobSubmissionEnabled();
    		assertTrue(Boolean.parseBoolean(besAdmin.isJobSubmissionEnabled()));
    	}
    }
}
