package de.fzj.unicore.bes.test;

import org.junit.Test;
import org.ogf.schemas.hpcp.x2007.x01.bp.BasicFilterDocument;
import de.fzj.unicore.bes.util.ActivityUtils;
import static org.junit.Assert.assertTrue;

/**
 * Simple test case to check HPC-BP's BasicFilter extension flags
 * 
 * @author m.memon
 * */

public class TestActivityUtils{
	
	protected BasicFilterDocument bfDoc;
	
	@Test
	public void testBasicFilterUtil(){
		bfDoc = (BasicFilterDocument)ActivityUtils.filterActivityAndResources();
		assertTrue( (bfDoc.getBasicFilter().getContainedResources())
			     && (bfDoc.getBasicFilter().getActivityReferences()) );

		bfDoc = (BasicFilterDocument)ActivityUtils.filterOnlyActivityBeans();
		assertTrue( (!bfDoc.getBasicFilter().getContainedResources())
			     && (bfDoc.getBasicFilter().getActivityReferences()) );

		bfDoc = (BasicFilterDocument)ActivityUtils.filterOnlyResourceBeans();
		assertTrue( (bfDoc.getBasicFilter().getContainedResources())
			     && (!bfDoc.getBasicFilter().getActivityReferences()) );

		bfDoc = (BasicFilterDocument)ActivityUtils.filterNoneBeans();
		assertTrue( (!bfDoc.getBasicFilter().getContainedResources())
			     && (!bfDoc.getBasicFilter().getActivityReferences()) );
	}
	
}
