package de.fzj.unicore.bes.test;

import java.io.File;

import javax.xml.namespace.QName;


import org.ggf.schemas.bes.x2006.x08.besFactory.ActivityDocumentDocument1;
import org.ggf.schemas.bes.x2006.x08.besFactory.ActivityStateEnumeration;
import org.junit.Test;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

import de.fzj.unicore.bes.activity.rp.ActivityDocumentRP;
import de.fzj.unicore.bes.activity.rp.BESActivityConverter;
import de.fzj.unicore.bes.factory.rp.ActivityReferenceRP;
import de.fzj.unicore.bes.functional.DateJSDL;
import de.fzj.unicore.bes.util.BESUtils;
import de.fzj.unicore.uas.UAS;
import de.fzj.unicore.uas.xnjs.XNJSFacade;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.Resource;
import de.fzj.unicore.wsrflite.security.TestConfigUtil;
import de.fzj.unicore.wsrflite.utils.Utilities;
import de.fzj.unicore.wsrflite.utils.WSServerUtilities;
import de.fzj.unicore.wsrflite.xmlbeans.impl.WSResourceImpl;
import de.fzj.unicore.xnjs.ems.Action;
import de.fzj.unicore.xnjs.ems.ActionStatus;
import static org.junit.Assert.*;

public class TestActivityRPs {

    @Test
    public void testSimpleAdd() throws Exception {
    	Kernel k=new Kernel(TestConfigUtil.getInsecureProperties());
    	ActivityReferenceRP activityRP = new ActivityReferenceRP(createMockResource(k));
        activityRP.add(createDummyEpr(k));
        assertTrue(activityRP.getNumberOfElements() == 1);
        assertFalse(activityRP.getXml()[0].toString().contains("dummy-activity-1"));
    }

    private EndpointReferenceType createDummyEpr(Kernel kernel) {
        String id = Utilities.newUniqueID();
        EndpointReferenceType eprt1 = WSServerUtilities.makeEPR(
        		"https://unicore/alpha/services/dummy-activity", id, kernel);
        WSServerUtilities.addUGSRefparamToEpr(eprt1, id);
        return eprt1;
    }

    @Test
    public void testMultipleActivityReferences() throws Exception {
    	Kernel k=new Kernel(TestConfigUtil.getInsecureProperties());
        ActivityReferenceRP a = new ActivityReferenceRP(createMockResource(k));
        final int n = 1000;

        String[] deletedIds = new String[3];

        for (int i = 0; i < n; i++) {
            EndpointReferenceType eprt = createDummyEpr(k);
            a.add(eprt);
            if (i < 3) {
                deletedIds[i] = WSServerUtilities.extractResourceID(eprt);
            }
        }

        assertEquals(a.getXml().length, n);
        a.remove(deletedIds[0]);
        assertEquals(a.getXml().length, n - 1);
        a.remove(deletedIds[1]);
        assertEquals(a.getXml().length, n - 2);
        a.remove(deletedIds[2]);
        assertEquals(a.getXml().length, n - 3);
    }

    @Test
    public void testActivityDocumentRP() {
        ActivityDocumentDocument1 acDoc = ActivityDocumentDocument1.Factory.newInstance();

        ActivityDocumentRP acRP = null;
        try {
            acRP = new ActivityDocumentRP(acDoc);
        } catch (Exception e) {
        }

        acDoc.addNewActivityDocument().addNewJobDefinition();
        acDoc.getActivityDocument().setJobDefinition(new DateJSDL().getJSDL().getJobDefinition());

        try {
            acRP = new ActivityDocumentRP(acDoc);
        } catch (Exception e) {
            fail();
        }

        ActivityDocumentDocument1 acDocTemp = (ActivityDocumentDocument1) acRP.getXml()[0];
        assertNotNull(acDocTemp.getActivityDocument());
        assertTrue(acDocTemp.getActivityDocument().getJobDefinition().getJobDescription().getApplication().getApplicationName().equalsIgnoreCase("Date"));

    }

    @Test
    public void testBESActivityConverter() throws Exception {
        BESUtils.deleteFile(new File("target", "data"));
        UAS uas = new UAS("src/test/resources/uas.config");
        Kernel kernel = uas.getKernel();
        XNJSFacade xnjs = XNJSFacade.get(null,kernel);
        final int N = 5;
        String[] arrayActivities = new String[N];
        try {
            for (int i = 0; i < N; i++) {
                Action a = xnjs.makeAction(new DateJSDL().getJSDL());
                a.getProcessingContext().put(Action.AUTO_SUBMIT, Boolean.TRUE);
                arrayActivities[i] = (String) xnjs.getManager().add(a, null);
                assertEquals(BESActivityConverter.getBESStatefromXNJSState(
                		kernel,
                        null, arrayActivities[i],
                        xnjs.getAction(arrayActivities[i]).getStatus()).getActivityStatus().getState(),
                        ActivityStateEnumeration.PENDING);
                while (xnjs.getAction(arrayActivities[i]).getStatus() != ActionStatus.DONE) {
                    Thread.sleep(500);
                    continue;
                }
                assertEquals(BESActivityConverter.getBESStatefromXNJSState(
                        kernel,
                		null, arrayActivities[i],
                        xnjs.getAction(arrayActivities[i]).getStatus()).getActivityStatus().getState(),
                        ActivityStateEnumeration.FINISHED);

            }
            xnjs.shutdown();
        } catch (Exception e) {
            fail();
        }
    }
    
	private Resource createMockResource(Kernel kernel){
		WSResourceImpl wsr=new WSResourceImpl() {
			@Override
			public QName getResourcePropertyDocumentQName() {
				// TODO Auto-generated method stub
				return null;
			}
		};
		wsr.setKernel(kernel);
		return wsr;
	}
}
