package de.fzj.unicore.bes.test;

import java.io.File;

import org.apache.commons.io.FileUtils;


import de.fzj.unicore.uas.UAS;
import de.fzj.unicore.wsrflite.Kernel;

public class EmbeddedServerStartup {

	
	private static boolean haveInit = false;

	/**
	 * Setup test environment, start UAS
	 */
	private static String serverUrl;

	private static Kernel kernel;
	
	public static void serverStartup() throws Exception {
		if (haveInit)return;
		
		FileUtils.deleteQuietly(new File("target/data"));
		
		UAS uas = new UAS("src/test/resources/uas.config");
		uas.startSynchronous();
		kernel=uas.getKernel();
		haveInit = true;
		serverUrl = kernel.getContainerProperties().getBaseUrl() + "/";
	}

	public static String getServerUrl(){
		return serverUrl;
	}
	
	public static Kernel getKernel(){
		return kernel;
	}
	
}
