package de.fzj.unicore.bes.performance;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.ggf.schemas.bes.x2006.x08.besFactory.ActivityStateEnumeration;
import org.ggf.schemas.bes.x2006.x08.besFactory.CreateActivityDocument;
import org.ggf.schemas.bes.x2006.x08.besFactory.CreateActivityResponseDocument;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.JobDefinitionType;
import org.junit.Test;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

import de.fzj.unicore.bes.client.FactoryClient;
import de.fzj.unicore.bes.functional.BaseActivityTest;
import de.fzj.unicore.wsrflite.utils.StopWatch;
import eu.unicore.util.httpclient.DefaultClientConfiguration;

/**
 * run performance tests against a localhost installation ("quickstart")
 * 
 */
public class TestLocalhost {

	String factoryURL="https://localhost:8080/DEMO-SITE/services/BESFactory?res=default_bes_factory";

	/**
	 * run N activities, then call terminateActivities()
	 */
	@Test
	public void runAndTerminateActivities()throws Exception{
		int N=1000;
		List<EndpointReferenceType>eprs=new ArrayList<EndpointReferenceType>();
		EndpointReferenceType fEPR=EndpointReferenceType.Factory.newInstance();
		fEPR.addNewAddress().setStringValue(factoryURL);
		DefaultClientConfiguration sec = BaseActivityTest.makeSecurityProperties();
		sec.getETDSettings().setExtendTrustDelegation(false);
		sec.setOutHandlerClassNames(null);
		
		FactoryClient fc=new FactoryClient(fEPR,sec);
		System.out.println("Connecting to: "+factoryURL+", server reply: "+fc.getCurrentTime());

		//submit some date's
		CreateActivityDocument req=CreateActivityDocument.Factory.newInstance();
		JobDefinitionType jobDefinition=JobDefinitionType.Factory.newInstance();
		jobDefinition.addNewJobDescription().addNewApplication().setApplicationName("Date");
		req.addNewCreateActivity().addNewActivityDocument().setJobDefinition(jobDefinition);
		StopWatch sw=new StopWatch();
		sw.start("Start tests with N = "+N);
		for(int i=0;i<N;i++){
			CreateActivityResponseDocument res=fc.createActivity(req);
			eprs.add(res.getCreateActivityResponse().getActivityIdentifier());
		}
		sw.snapShot("End creating activities.");

		List<EndpointReferenceType>doneEprs=new ArrayList<EndpointReferenceType>();

		//check status
		sw.snapShot("Start check status");
		while(eprs.size()>0){
			sw.snapShot("Check status for "+eprs.size()+" activities.");
			Iterator<EndpointReferenceType>iter=eprs.iterator();
			while(iter.hasNext()){
				EndpointReferenceType epr=iter.next();
				ActivityStateEnumeration.Enum s=fc.getActivityStatus(epr);
				if(ActivityStateEnumeration.FINISHED.equals(s) || ActivityStateEnumeration.FAILED.equals(s)){
					doneEprs.add(epr);
					iter.remove();
				}
			}
		}
		sw.snapShot("End check status");

		//terminate
		sw.snapShot("Start terminate activities");
		sw.snapShot("Terminate activities for "+doneEprs.size()+" activities.");
		Iterator<EndpointReferenceType>iter=doneEprs.iterator();
		while(iter.hasNext()){
			EndpointReferenceType epr=iter.next();
			fc.terminateActivity(epr);
		}
		sw.snapShot("End terminate activities");
		
		sw.stop("End of test.");
		System.out.println(sw.toString());
	}

}
