package de.fzj.unicore.bes.glue;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;
import static org.junit.Assert.fail;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

import org.apache.xmlbeans.XmlException;
import org.junit.Test;
import org.ogf.schemas.glue.x2009.x03.spec20R1.AdminDomainT;
import org.ogf.schemas.glue.x2009.x03.spec20R1.ComputingServiceT;
import org.ogf.schemas.glue.x2009.x03.spec20R1.DomainsDocument;
import org.ogf.schemas.glue.x2009.x03.spec20R1.DomainsT;

public class TestGlueProperties{
	
	final String glueFilePath = "src/test/resources/glue/glue2instance.xml";
	
	@Test
	public void testPropertiesFromFile() throws FileNotFoundException{
		DomainsDocument g = null;
		try {
			g = DomainsDocument.Factory.parse(new File(glueFilePath));
		} catch (XmlException e) {
			e.printStackTrace();
			fail();
		} catch (IOException e) {
			e.printStackTrace();
			fail();
		}
		assertTrue(g.getDomains().getAdminDomainArray().length>0);
		assertTrue(g.getDomains().getAdminDomainArray()[0].getOwnerArray().length>0);
		assertNotNull(g.getDomains().getAdminDomainArray()[0].getOwnerArray()[0]);
		ComputingServiceT  cs=g.getDomains().getAdminDomainArray(0).getComputingServiceArray(0);
		assertNotNull(cs);
		assertEquals("urn:fzj:jsc:bes",cs.getID());
	}
	
	@Test
	public void testBeans(){
		String testUrn = "urn:test";
		DomainsDocument gd = DomainsDocument.Factory.newInstance();
		DomainsT gt = gd.addNewDomains();
		AdminDomainT at = gt.addNewAdminDomain();
		at.addNewContact().setID(testUrn);
		at.addNewComputingService().addNewAssociations().addServiceID("123");
		assertTrue(gd.getDomains().getAdminDomainArray()[0].getContactArray()[0].getID().equals(testUrn));
	}
	
	
}
